/**
 * $Id: ProtectedTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.wrap.ProtectedTaskSet
 * ProtectedTaskSet}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class ProtectedTaskTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new ProtectedTaskTest testcase.
     **/
    public ProtectedTaskTest(String methodName)
    {
        super("ProtectedTaskSet::",methodName);
    }


    /**
     * Create full test suite for ProtectedTaskSet.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ProtectedTaskTest.class);
    }


    /**
     * Create baseline test suite for ProtectedTaskSet (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(ProtectedTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("protect.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testCanFreeNestProtectionHelpers()
    {
        configureProjectFromResource("broken_protect0.xml");
        expectBuildException("testCantFreeNestIfError","IfError Requires ProtectedBlock");
        expectBuildException("testCantFreeNestAlways","Always Requires ProtectedBlock");
    }

    public void testPropagateBarfsByDefault()
    {
        runExpecting("testBarfsByDefault","Failed Assertion");
    }

    public void testConsumesBarfsIfNoHalt()
    {
        String log= runTarget("testConsumeBarfage");
        verifyOccurances(log,"((END))",1);
    }

    public void testAlwaysNoError()
    {
        String log= runTarget("testAlwaysNoError");
        verifyOccurances(log,"helloworld((ALWAYS))",1);
    }

    public void testAlwaysWithError()
    {
        String log= runExpecting("testAlwaysWithError","Failed-Assertion");
        verifyOccurances(log,"helloworld((ALWAYS))",1);
    }

    public void testIfError()
    {
        String log= runExpecting("testIfError","Failed-Assertion");
        verifyOccurances(log,"helloworld((IFERROR))",1);
        println("Failure Property: "+getProject().getProperty("the.barfage"));
    }

    public void testIfErrorBeforeAlways()
    {
        String log= runTarget("testIfErrorBeforeAlways");
        verifyOccurances(log,"helloworld((ALWAYS))",1);
        verifyOccurances(log,"helloworld((END))",1);
    }

    public void testHelpersOrderUnimportant()
    {
        String log= runTarget("testHelperOrderUnimportant");
        verifyOccurances(log,"helloworld((ALWAYS))",1);
        verifyOccurances(log,"helloworld((IFERROR))",1);
        verifyOccurances(log,"hiworld((notreached))",0);
        String[] strings = {"hiworld((0))","hiworld((1))",
                            "helloworld((IFERROR))", "helloworld((ALWAYS))",
                            "byeworld((TARGET))"};
        verifyOutputInOrder(log, strings);
    }

    public void testNestedProtectedBlocks()
    {
        String log= runTarget("testNestingBlocks");
        verifyOccurances(log,"hiworld((outer.notreached))",0);
        verifyOccurances(log,"hiworld((inner.notreached))",0);

        String[] strings = {"hiworld((outer.0))",
                            "hiworld((inner.0))",
                            "byeworld((IFERROR.inner))",
                            "helloworld((ALWAYS.inner))",
                            "helloworld((ALWAYS.postcleanup))",
                            "helloworld((ALWAYS.outer))",
                            "byeworld((TARGET))"};
        verifyOutputInOrder(log, strings);
    }

    public void testCapturedErrorSnapshots()
    {
        String log = runTarget("testCaptureIfError");
        verifyOccurances(log,"p.1=",1);
        verifyOccurances(log,"p.2=",1);
    }

//    public void testConditionalIfBlock()
//    {
//        runTargetNoOutput("testProtectConditionalIfFalse");
//    }
//
//    public void testConditionalUnlessBlock()
//    {
//        runTargetNoOutput("testProtectConditionalUnlessTrue");
//    }

    public void testBadExports()
    {
        runTarget("testBadExports");
    }

    public void testBadTally()
    {
        runTargetDumpFullLog("testBadTally");
    }

    public void testBadAssertLogged()
    {
        runTarget("testBadAssertLogged");
    }

    /** @since JWare/AntX 0.3 **/
    public void testRulesAndCallerUpdateProperties_AntX03()
    {
        runTarget("testRulesAndCallerUpdateProperties");
    }

    /** @since JWare/AntX 0.4 **/
    public void testCanWrapMacroMakerBody_AntX04()
    {
        runTarget("testCanWrapMacroMakerBody_AntX04");
    }

    /** @since JWare/AntX 0.4 **/
    public void testBadFixtureChecks_AntX04()
    {
        runTarget("testBadFixtureChecks_AntX04");
    }
}

/* end-of-ProtectedTaskTest.java */
