/**
 * $Id: OnceTaskTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.call.OnceTask OnceTask}.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public final class OnceTaskTest extends StepCallerTestSkeleton
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new OnceTaskTest testcase.
     **/
    public OnceTaskTest(String methodName)
    {
        super("OnceTask::",methodName);
    }


    /**
     * Create full test suite for OnceTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(OnceTaskTest.class);
    }


    /**
     * Create baseline test suite for OnceTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();//new BaselineSuite(OnceTaskTest.class);
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected String getDefaultConfigureXMLFileName()
    {
        return "once.xml";
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void testFailEmptyElement()
    {
        expectBuildException("testOnceFailEmpty", "Empty definition");
    }

    public void testRequireEitherStepsOrTargetsNotBoth()
    {
        expectBuildException("testOnceRequiresEitherStepsOrTargets",
                             "Either 'steps' or 'targets' not both");
    }

    public void testFailUnknownSteps()
    {
        expectBuildException("testOnceStepsFailUnknown", "Unknown steps");
    }

    public void testFailUnknownTargets()
    {
        expectBuildException("testOnceTargetsFailUnknown", "Unknown target");
    }

    public void testFailStepsWithNoName()
    {
        configureProjectFromResource("broken_step0.xml");
        expectBuildException("testNoNameFailOnExec", "Un-named steps");
    }

    public void testFailNestedSteps()
    {
        verifyCantLoadFile("broken_step1.xml", "nested 'step' elements");
    }

//      public void testFailingIff()
//      {
//          runTarget("testFailIff");
//      }

//      public void testFailingIffTrue()
//      {
//          runTarget("testFailIffTrue");
//      }

//      public void testFailingUnless()
//      {
//          runTarget("testFailUnless");
//      }

//      public void testFailingUnlessTrue()
//      {
//          runTarget("testFailUnlessTrue");
//      }

//      public void testFailingIfUnless()
//      {
//          runTarget("testFailIfUnless");
//      }

    public void testTargetsJustRunIt()
    {
        runTarget("testOnceTargetsRunIt");
        verifyTargetsRanInOrder("f",1,2,0);
    }

    public void testTargetsRunItAndDependencies()
    {
        runTarget("testOnceTargetsRunItDependencies");
        int iF3= verifyTargetsRanInOrder("f",2,3,0);
        verifyTargetsRanInOrder("f",2,4,iF3);
    }

    public void testTargetsInheritAllByDefault()
    {
        runTarget("testOnceTargetsInheritAllByDefault");
        int ilastInheritedMatch= verifyTargetsInheritedParent(1,1,0);
        ilastInheritedMatch= verifyTargetsInheritedParent(2,4,ilastInheritedMatch);
    }

    public void testTargetsInheritNone()
    {
        runTarget("testOnceTargetsInheritNone");
        int iF1= verifyTargetsRanInOrder("f",1,1,0);
        verifyTargetsRanInOrder("f",2,4,iF1);
    }

    public void testTargetsHaltIfErrorByDefault()
    {
        verifyHaltedBeforeF2Run("testOnceTargetsHaltIfErrorByDefault","((T2))");
    }

    public void testTargetsTryEach()
    {
        runTarget("testOnceTargetsTryEach");
        assertPropertyEquals("something.barfed","true");
    }

    public void testTargetsHaltOverridesTryEach()
    {
        verifyHaltedBeforeF2Run("testOnceTargetsHaltOverridesTryEach","((T2))");
    }

    public void testStepsFindLauncher()
    {
        runTarget("testOnceStepsFindLauncher");
    }

    public void testStepsJustRunIt()
    {
        runTarget("testOnceStepsRunIt");
        verifyTargetsRanInOrder("s",1,2,0);
    }

    public void testStepsRunItIff()
    {
        String log = runTarget("testOnceStepsRunItIff");
        int last = verifyTargetsRanInOrder("s",1,1,0);
        verifyTargetsRanInOrder("s",1,2,last);
        verifyOccurances(log,"[((S2))]",1);
    }

    public void testStepsRunUnless()
    {
        String log = runTarget("testOnceStepsRunItUnless");
        assertPropertyEquals("from.s1",null);
        verifyTargetsRanInOrder("s",1,1,0);
        verifyOccurances(log,"((S1))",1);
        verifyOccurances(log,"mama",0);
    }

    public void testStepsInheritParamsOverAll()
    {
        String log = runTarget("testOnceStepInheritParams");
        verifyTargetsRanInOrder("s",1,2,0);
        verifyOccurances(log,"400",2);
        verifyOccurances(log,"200",0);
        verifyOccurances(log,"300",0);
    }

    public void testStepsHaltIfErrorByDefault()
    {
        verifyHaltedBeforeF2Run("testOnceStepsHaltIfErrorByDefault","((S2))");
    }

    public void testStepsTryEach()
    {
        runTarget("testOnceStepsTryEach");
        assertPropertyEquals("something.barfed","true");
    }

    public void testStepsHaltOverridesTryEach()
    {
        verifyHaltedBeforeF2Run("testOnceStepsHaltOverridesTryEach","((S2))");
    }

    public void testStepsCanCallRealTargets()
    {
        String log = runTarget("testOnceNestedAntCallsInSteps");
        verifyTargetsRanInOrder("f",2,4,0);
        verifyOccurances(log,AT+"999",3);
    }

    /** @since JWare/AntX 0.2 **/
    public void testCopyPropertyTask_AntX02()
    {
        runTargetDumpFullLog("testCopyProperty");
    }

    /** @since JWare/AntX 0.3 **/
    public void testCopyReferenceToChildProject_AntX03()
    {
        runTarget("testCopyReferenceToChildProject_AntX03");
    }

    /** @since JWare/AntX 0.4 **/
    public void testNestedPropertySets_AntX04()
    {
        runTarget("testNestedPropertySets_AntX04");
    }
    
    /** @since JWare/AntX 0.5 **/
    public void testCannotCombineMacrosWithOthers_AntX05()
    {
        runTarget("testCannotCombineMacrosWithOthers_AntX05");
    }
    
    /** @since JWare/AntX 0.5 **/
    public void testCallLocalMacros_AntX05()
    {
        runTarget("testCallLocalMacros_AntX05");
    }
    
    public void testCallLocalConfiguredMacros_AntX05()
    {
        runTarget("testCallLocalConfiguredMacros_AntX05");
    }
    
    public void testCallLocalOverlayedMacros_AntX05()
    {
        runTarget("testCallLocalOverlayedMacros_AntX05");
    }
}

/* end-of-OnceTaskTest.java */
