/**
 * $Id: ConditionalTaskSetTest.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.tests;

import  junit.framework.TestSuite;

import  com.idaremedia.antx.ut.HTC;
import  com.idaremedia.antx.ut.HTCUtils;

/**
 * Class test for {@linkplain com.idaremedia.antx.flowcontrol.ConditionalTaskSet
 * ConditionalTaskSet}.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,test
 **/

public class ConditionalTaskSetTest extends HTC
{
    /** <i>PET</i> Test Category. **/
    public static final String TEST_CATEGORY="CLASS";


    /**
     * Create new ConditionalTaskSetTest testcase.
     **/
    public ConditionalTaskSetTest(String methodName)
    {
        super("ConditionalTaskSet::",methodName);
    }


    /**
     * Create full test suite for AssertTask.
     **/
    public static TestSuite suite()
    {
        return new TestSuite(ConditionalTaskSetTest.class);
    }


    /**
     * Create baseline test suite for AssertTask (same as full).
     **/
    public static TestSuite baseline()
    {
        return suite();
    }


    /**
     * Make this test (standalone) self-running.
     **/
    public static void main(String[] argv)
    {
        HTCUtils.quickCheck(suite());
    }


// ---------------------------------------------------------------------------------------------------------
// ---------------------------------------- [ Misc Setup Methods ] -----------------------------------------
// ---------------------------------------------------------------------------------------------------------

    protected void setUp() throws Exception
    {
        configureProjectFromResource("do.xml");
    }

// ---------------------------------------------------------------------------------------------------------
// ------------------------------------------- [ The Test Cases ] ------------------------------------------
// ---------------------------------------------------------------------------------------------------------

    public void checkBaseline()
    {
        //--Ensures setUp() works and can find our xml file!
    }

    public void testBaseline()
    {
        checkBaseline();
    }

    public void testAlways()
    {
        runTarget("testDoAlways");
    }

    public void testIfConditional()
    {
        runTarget("testIfConditional");
    }

    public void testIfTrueConditional()
    {
        runTarget("testIfTrueConditional");
    }

    public void testUnlessConditional()
    {
        runTarget("testUnlessConditional");
    }

    public void testUnlessTrueConditional()
    {
        runTarget("testUnlessTrueConditional");
    }

    public void testNestedDosAndDonts()
    {
        String log = runTarget("testNestedDoAndDonts");
        assertTrue(log.indexOf("BROKEN(c.3)") == -1, "c.3 never executed");
    }

    public void testAntConditions_AntX04()
    {
        runTarget("testAntConditions_AntX04");
    }

    public void testOsConditions_AntX04()
    {
        runTarget("testOsConditions_AntX04");
    }

    public void testMultiSetConditions_AntX04()
    {
        runTarget("testMultiSetConditions_AntX04");
    }

    public void testMultiTrueConditions_AntX04()
    {
        runTarget("testMultiTrueConditions_AntX04");
    }

    public void testComboAllConditions_AntX04()
    {
        runTarget("testComboAllConditions_AntX04");
    }
    
    public void testTrueValueConditions_AntX05()
    {
        runTarget("testTrueValueConditions_AntX05");
    }
    
    public void testFalseValueConditions_AntX05()
    {
        runTarget("testFalseValueConditions_AntX05");
    }
    
    public void testExternalTests_AntX05()
    {
        runTarget("testExternalTests_AntX05");
    }
}


/* end-of-ConditionalTaskSetTest.java */
