/**
 * $Id: ChoiceTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.match;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.Task;
import  org.apache.tools.ant.types.Reference;

import  com.idaremedia.antx.helpers.TaskHandle;
import  com.idaremedia.antx.parameters.FlexValueSupport;
import  com.idaremedia.antx.starters.Quiet;
import  com.idaremedia.antx.starters.StrictInnerTaskSet;

/**
 * Required superclass for any nested choice selector task. This class defines
 * the required evaluation and filtering methods for all choice task sets.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 * @see      SwitchTask
 **/

public abstract class ChoiceTask extends StrictInnerTaskSet
    implements Quiet, FlexValueSupport
{
    /**
     * Initializes new choice task.
     **/
    protected ChoiceTask(String iam)
    {
        super(iam);
    }



    /**
     * Initializes new choice task with custom delay configuration.
     * @param iam CV-label
     * @param delayConfiguration <i>true</i> if delay nested task configuration
     **/
    protected ChoiceTask(String iam, boolean delayConfiguration)
    {
        super(iam,delayConfiguration);
    }



    /**
     * Returns this choice's underlying match value (as-is).
     * @since JWare/AntX 0.2
     **/
    public abstract String getFlexValue();



    /**
     * Returns <i>true</i> if this choice has not been defined properly.
     **/
    public abstract boolean isUndefined();



    /**
     * Returns the actual value used in this choice's comparision. Returns
     * <i>null</i> if value never defined or determined value doesn't
     * exist; for example, if the named reference doesn't exist in project.
     **/
    public abstract String getVUT();



    /**
     * Returns <i>true</i> if task is not another choice task
     * definition. Cannot nest choices directly into one another.
     **/
    protected boolean includeTask(TaskHandle taskH)
    {
        Task task = candidateTask(taskH,COI_);
        return (task!=null) && !(task instanceof ChoiceTask);
    }



    /**
     * Evaluates this choice's condition for a hit. Returns
     * <i>true</i> if this choice's criteria are met by the incoming
     * value under consideration.
     * @param vut value under test (vut-vut)
     * @param context [optional] evaluation context
     * @throws BuildException if this task isn't nested properly
     **/
    public abstract boolean eval(String vut, Reference context)
        throws BuildException;



    /**
     * Ensure this choice has had its match value assigned and exists
     * within a valid block task.
     **/
    protected void verifyCanExecute_(String calr)
    {
        super.verifyCanExecute_(calr);

        if (isUndefined()) {
            String ermsg = uistrs().get("flow.switch.needs.value",getTaskName());
            log(ermsg, Project.MSG_ERR);
            throw new BuildException(ermsg,getLocation());
        }
    }



    /**
     * Controls the amount of peek-under for UnknownElement placeholders
     * nested inside task containers.
     * @since JWare/AntX 0.4
     **/
    private static final Class[] COI_= {
        ChoiceTask.class
    };
}

/* end-of-ChoiceTask.java */
