/**
 * $Id: TargetCaller.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.call;

import  java.util.Map;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.taskdefs.Ant;
import  org.apache.tools.ant.taskdefs.Property;
import  org.apache.tools.ant.types.PropertySet;

/**
 * Helper that calls a another target whether that target is inlined or top-level.
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   impl,infra
 * @see      OverlayParametersHelper
 **/

public interface TargetCaller
{
    /**
     * Returns this caller's target's name.
     **/
    String getTargetName();


    /**
     * Returns the step on whose behave this caller exists.
     **/
    String getStepName();


    /**
     * Create a new property to passthru to called target.
     **/
    Property createProperty();


    /**
     * Create a new propertyset to passthru to called target.
     * @since JWare/AntX 0.4
     **/
    PropertySet createPropertySet();


    /**
     * Create a new reference to passthru to called target.
     * @since JWare/AntX 0.3
     **/
    Ant.Reference createReference();


    /**
     * Executes the target this caller references.
     * @throws BuildException if target does.
     **/
    void run() throws BuildException;


    /**
     * Convenient {@linkplain #run() run} alternative that auto-installs
     * a required property into the to-be-called target's runtime
     * environment before it's executed. Useful for looping constructs
     * that call targets as part of their execution w/ a changing
     * cursor property.
     * @param property property name (non-null)
     * @param value property value-- used as-is no additional
     *              replacements are done (non-null)
     * @throws BuildException if target does.
     **/
    void run(String property, String value)
        throws BuildException;


    /**
     * Convenient {@linkplain #run() run} alternative that auto-installs
     * contents of properties map into the to-be-called target's runtime
     * environment before it's executed.
     * @param properties properties to be installed (non-null)
     * @throws BuildException if target does.
     * @since JWare/AntX 0.4
     **/
    void run(Map properties)
        throws BuildException;


    /**
     * Convenient {@linkplain #run() run} alternative that auto-installs
     * arbitrary numbers of fixture data into the to-be-called target's
     * runtime environment before it's executed.
     * @param prep client preparation snippet (non-null)
     * @throws BuildException if target does.
     **/
    void run(TargetCaller.Prep prep)
        throws BuildException;



    /**
     * Helper that lets caller task select which TargetCaller run method to use.
     * @since    JWare/AntX 0.1
     * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.pattern GoF.Strategy
     **/
    interface RunSelector {
        /**
         * Run the caller using the appropriate run-method variant.
         * @param caller the caller to be run (non-null)
         * @throws BuildException if target does.
         **/
        void run(TargetCaller caller) throws BuildException;
    }



    /**
     * Helper that lets caller task prepare a custom runtime environment for
     * a to-be-called target.
     * @since    JWare/AntX 0.1
     * @author   ssmc, &copy;2002-2003 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
     * @version  0.5
     * @.pattern GoF.Strategy
     **/
    interface Prep {
        /**
         * Called to prepare the passthru environment appropriately before
         * the to-be-executed target.
         * @param caller the caller that will run the target (non-null)
         * @throws BuildException if unable to prepare target.
         **/
        void prepare(TargetCaller caller) throws BuildException;
    }
}

/* end-of-TargetCaller.java */

