/**
 * $Id: OverlayParametersHelper.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.call;

import  java.util.List;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.Task;
import  org.apache.tools.ant.TaskContainer;
import  org.apache.tools.ant.taskdefs.Ant;
import  org.apache.tools.ant.taskdefs.Property;
import  org.apache.tools.ant.types.PropertySet;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.AntXFixture;
import  com.idaremedia.antx.helpers.InnerNameValuePair;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.ownhelpers.ProjectDependentSkeleton;
import  com.idaremedia.antx.solo.CopyReferenceTask;

/**
 * Helper that interprets nested property and reference copying instructions
 * for target callers. Originally part of the {@linkplain OnceTask}.
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,helper
 * @see      CallerTask
 **/

public final class OverlayParametersHelper extends ProjectDependentSkeleton
{
    private static final String IAM_= AntX.utilities+"OverlayParametersHelper";


    /**
     * Initializes a new helper instance.
     **/
    public OverlayParametersHelper()
    {
    }


    /**
     * Initializes a new helper instance and associates
     * w/ given project.
     * @param project target project (non-null)
     **/
    public OverlayParametersHelper(Project project)
    {
        setProject(project);
    }



    /**
     * Tells this overlay helper to defer parameter addition
     * to another component.
     * @param tc the thing to which we will defer
     **/
    public void addOverride(TaskContainer tc)
    {
        m_deferredTo = tc;
    }



    /**
     * Returns this helper's active parameters list. Never returns
     * <i>null</i> but can be empty list. Modifications to returned
     * list are seen by this helper.
     **/
    protected List getParameters()
    {
        return m_paramsList;
    }



    /**
     * Adds another parameter to this helper's active list. Item
     * should be one of the accepted fixture controls (like a
     * &lt;copyproperty&gt; or &lt;propertyset&gt;).
     * @param item the configuration control (non-null)
     **/
    public void addParameter(Object item)
    {
        AntX.require_(item!=null,IAM_,"add- nonzro item");
        if (m_deferredTo!=null && (item instanceof Task)) {
            m_deferredTo.addTask((Task)item);
        } else {
            m_paramsList.add(item);//?possible leak?
        }
    }



    /**
     * Copies this helper's configuration instructions to the
     * target caller's environment.
     * @param helper the caller to configure (non-null)
     * @throws BuildException if malformed instruction(s) found.
     **/
    public void transferParameters(TargetCaller helper)
    {
        List params = getParameters();
        for (int i=0,N=params.size();i<N;i++) {
            Object param = params.get(i);
            if (param instanceof Property) {
                Property source = (Property)param;
                Property dest = helper.createProperty();
                Tk.transferProperty(source, dest);
                if (dest.getValue()==null) {
                    String attr = "value|property|variable|reference";
                    String ermsg = AntX.uistrs().get("task.needs.this.attr",
                                                     source.getTaskName(),attr);
                    source.log(ermsg,Project.MSG_ERR);
                    throw new BuildException(ermsg,source.getLocation());
                }
            }
            else if (param instanceof PropertySet) {
                PropertySet dest = helper.createPropertySet();
                dest.addPropertyset((PropertySet)param);
            }
            else if (param instanceof CopyReferenceTask) {
                CopyReferenceTask source = (CopyReferenceTask)param;
                source.verifyExists(getProject(),null,null);
                Ant.Reference dest = helper.createReference();
                if (dest!=null) {
                    dest.setRefId(source.getRefId());
                    dest.setToRefid(source.getToRefId());
                } else {
                    String warning = AntX.uistrs().
                        get("taskset.nested.task.disallowed",
                            "reference","call+mode=local");//?hack?
                    source.log(warning,Project.MSG_WARN);
                }
            }
            else if (param instanceof InnerNameValuePair) {
                if (helper instanceof ConfigurableCaller) {
                    ConfigurableCaller cc = (ConfigurableCaller)helper;
                    InnerNameValuePair source = (InnerNameValuePair)param;
                    InnerNameValuePair dest = cc.createAttribute();
                    dest.setNV(source.getName(),source.getValue());
                } else {
                    InnerNameValuePair source = (InnerNameValuePair)param;
                    source.verifyNamed();
                    Property dest = helper.createProperty();
                    dest.setName(source.getName());
                    dest.setValue(source.getValue());
                }
            }
        }
    }


    private List m_paramsList= AntXFixture.newList();
    private TaskContainer m_deferredTo;
}

/* end-of-OverlayParametersHelper.java */
