/**
 * $Id: InlineStep.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your option) any later
 * version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.flowcontrol.call;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.Task;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.flowcontrol.ConditionalTaskSet;
import  com.idaremedia.antx.helpers.TaskHandle;
import  com.idaremedia.antx.helpers.Tk;
import  com.idaremedia.antx.starters.Quiet;

/**
 * A series of tasks defined as an inner target. Steps are passive (do nothing via
 * the standard Ant-execution mechanism). Steps must be actively executed indirectly
 * through a CallerTask control task (like a &lt;callforeach&gt; or  &lt;call&gt;).
 * <p>
 * To use call steps you <em>must</em> define the special AntX step-launch target;
 * see {@linkplain StepLauncherInstallTask}.
 * <p>
 * <b>Example Usage:</b><pre>
 *    &lt;target name="TheTarget"&gt;
 *        &lt;step name="clean"&gt;
 *            &lt;delete quiet="true" includeEmptyDir="yes" dir="..."/&gt;
 *        &lt;/step&gt;
 *        &lt;step name="extract"&gt;
 *            &lt;cvs dest="..." command="update -d" .../&gt;
 *            &lt;checkpoint tofile=".../checkout.last"/&gt;
 *        &lt;/step&gt;
 *        &lt;step name="transform"&gt;
 *            &lt;copy todir="...">...&lt;/copy&gt;
 *            &lt;xslt .../&gt;
 *            &lt;checkpoint tofile=".../merged.last"/&gt;
 *        &lt;/step&gt;
 *        ...
 *        &lt;callforeach i="module" list="${module.list}"
 *                        steps="clean,extract,transform"/&gt;
 *        ...
 *    &lt;/target&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   impl,infra
 **/

public class InlineStep extends ConditionalTaskSet
    implements Quiet, InlinedTarget, InlinedTargetContainer
{
    /**
     * Initializes a new empty step.
     **/
    public InlineStep()
    {
        super(AntX.flow+"step");
    }


    /**
     * Initializes a new CV-labeled empty step.
     * @param iam CV-label (non-null)
     **/
    protected InlineStep(String iam)
    {
        super(iam);
    }


    /**
     * Sets this step's name.
     * @param name new name (non-null)
     **/
    public void setName(String name)
    {
        require_(name!=null,"setName- nonzro name");
        m_name = name;
    }


    /**
     * Returns this step's name; returns <i>null</i>
     * if never set.
     **/
    public String getName()
    {
        return m_name;
    }


    /**
     * Returns this step's name (can be the string "null").
     **/
    public String toString()
    {
        return getName();
    }


    /**
     * Returns <i>true</i> if task is not another inline step
     * definition. For now, cannot nest inline steps.
     **/
    protected boolean includeTask(TaskHandle taskH)
    {
        Task task = candidateTask(taskH,COI_);
        return (task!=null) && !(task instanceof InlineStep);
    }


    /**
     * No-op. Steps are explicitly run from StepLauncher's
     * sending message to the step's {@linkplain #run run} method.
     **/
    public void execute()
    {
        verifyCanExecute_("execute");
        //ssshhhhh....
    }


    /**
     * Runs sub-tasks iff if/unless conditions met. Otherwise,
     * behaves like the standard Ant <i>sequential</i> task.
     **/
    public void run() throws BuildException
    {
        verifyCanExecute_("run");

        //NOTE: should there be a call to maybeConfigure here (ssmc)
        //getRuntimeConfigurableWrapper().maybeConfigure(getProject(),true);

        performNestedTasks();
    }


    /**
     * Ensure this step has been named.
     **/
    protected void verifyCanExecute_(String calr)
        throws BuildException
    {
        super.verifyCanExecute_(calr);

        if (Tk.isWhitespace(getName())) {
            String ermsg = uistrs().get("flow.task.needs.name",this.getTaskName());
            log(ermsg, Project.MSG_ERR);
            throw new BuildException(ermsg, getLocation());
        }
    }


    private String  m_name;//NB:required


    /**
     * Controls the amount of peek-under for UnknownElement placeholders
     * nested inside task containers.
     * @since JWare/AntX 0.4
     **/
    private static final Class[] COI_= {
        InlineStep.class
    };
}

/* end-of-InlineStep.java */
