/**
 * $Id: Preference.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition.solo;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;

import  com.idaremedia.antx.AntX;
import  com.idaremedia.antx.starters.Quiet;
import  com.idaremedia.antx.starters.StrictInnerTask;
import  com.idaremedia.antx.starters.StrictOuterTask;

/**
 * A {@linkplain BuildRule} item that checks if some requirement would be violated in
 * the current project's state and tries to adjust the project to prevent a subsequent
 * check of that same requirement from evaluating negatively. A build rule
 * will never fail because of a <i>false</i> preference.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  guarded
 * @.group   api,infra
 * @see      BuildRule
 * @see      Requirement
 **/

final class Preference extends PreferTask implements StrictInnerTask,Quiet
{
    /**
     * Initializes a new build rule preference instance.
     **/
    Preference()
    {
        super(AntX.rules+"prefer",true);
    }


    /**
     * Associates this preference with its enclosing build rule.
     * @param enclosingTask enclosing {@linkplain BuildRule build rule} (non-null)
     **/
    public void setEnclosingTask(StrictOuterTask enclosingTask)
    {
        require_((enclosingTask instanceof BuildRule), "setEnclTsk- only buildrule");
        m_owningRule = enclosingTask;
    }


    /**
     * Returns the {@linkplain BuildRule build rule} in which this
     * preference is nested. Returns <i>null</i> if never set.
     **/
    public StrictOuterTask getEnclosingTask()
    {
        return m_owningRule;
    }


    /**
     * Verifies in a valid project and nested within a build rule.
     * @throws BuildException if not in project and/or build rule
     **/
    protected void verifyCanExecute_(String calr)
    {
        verifyInProject_(calr);
        if (getEnclosingTask()==null) {
            String ermsg = uistrs().get("task.only.in.outer",getTaskName(),"rule");
            log(ermsg,Project.MSG_ERR);
            throw new BuildException(ermsg);
        }
    }

    private StrictOuterTask m_owningRule;
}

/* end-of-Preference.java */
