/**
 * $Id: IsNotSet.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.condition;

import  com.idaremedia.antx.parameters.Handling;
import  com.idaremedia.antx.parameters.IgnoreWhitespaceEnabled;
import  com.idaremedia.antx.parameters.IsA;

/**
 * Simple Is-Not-Set condition check. Example usage:
 * <pre>
 *   &lt;isnotset property="jdk14.present"/&gt;
 *   &lt;isnotset property="module.id" whitespace="ignore"/&gt;
 *   &lt;isnotset variable="__loopcount"/&gt;
 *   &lt;isnotset reference="build.num"/&gt;
 *</pre>
 *
 * @since    JWare/AntX 0.1
 * @author   ssmc, &copy;2002-2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 **/

public class IsNotSet extends SimpleFlexCondition implements IgnoreWhitespaceEnabled
{
    /**
     * Initializes new IsNotSet condition. A value type must be
     * specified before this condition is evaluated.
     **/
    public IsNotSet()
    {
        super();
    }


    /**
     * Initializes a fully-defined IsNotSet condition.
     * @param property the property against which condition checks
     **/
    public IsNotSet(String property)
    {
        setProperty(property);
    }


    /**
     * Initializes an IsNotSet condition to either a property or
     * a variable value check.
     * @param value the property or varaible against which
     *            condition checks
     * @param isP <i>true</i> if <span class="src">value</span> is
     *            property's name
     **/
    public IsNotSet(String value, boolean isP)
    {
        if (isP) {
            setProperty(value);
        } else {
            setVariable(value);
        }
    }



    /**
     * Sets whether a property containing only whitespace is
     * considered "not-set."
     **/
    public void setWhitespace(Handling response)
    {
        getValueHelper().setWhitespace(response);
    }


    /**
     * Returns <i>true</i> if values of all whitespace will be
     * ignored (as if not set). Defaults <i>false</i>.
     **/
    public final boolean ignoreWhitespace()
    {
        return getValueHelper().isIgnoreWhitespace();
    }



    /**
     * Marks this condition's property as the default field
     * set by a value URI.
     * @since JWare/AntX 0.5
     * @return IsA.PROPERTY always.
     */
    protected IsA getDefaultIsAForURI()
    {
        return IsA.PROPERTY;
    }



    /**
     * Returns <i>true</i> if this condition's property, reference,
     * or variable has not been explicitly set.
     **/
    public boolean eval()
    {
        verifyCanEvaluate_("eval");

        if (isReference()) {
            Object o = getProject().getReference(getResolvedFlexValue());
            if (!(o instanceof String)) {//otherwise apply modifiers(ssmc)
                return o==null;
            }
        }

        return getValueHelper().getValue()==null;
    }
}

/* end-of-IsNotSet.java */
