/**
 * $Id: EmptyLogs.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2002-2003,2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your option) any
 * later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL (GNU Lesser General Public License) for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                           EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture;

import  com.idaremedia.antx.NoiseLevel;

/**
 * An always-empty placeholder for a LogsRecorder.
 *
 * @since    JWare/AntX 0.2
 * @author   ssmc, &copy;2002-2003,2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  n/a
 * @.group   impl,helper
 * @.pattern JWare.NullProxy
 **/

public final class EmptyLogs implements LogsRecorder
{
    /**
     * VM/ClassLoader shareable instance of an EmptyLogs object.
     **/
    public static final EmptyLogs INSTANCE= new EmptyLogs();



    /**
     * Initializes new instance of an EmptyLogs object.
     **/
    public EmptyLogs()
    {
    }


    /**
     * Always returns <i>false</i> since this recorder
     * never records any messages.
     * @param nl noise level (non-null)
     **/
    public boolean isImportant(NoiseLevel nl)
    {
        return false;
    }


    /**
     * Always returns an empty string since this recorder
     * records nothing.
     **/
    public String copyOfImportantLogs()
    {
        return "";
    }


    /**
     * Always returns an empty string since this recorder
     * records nothing.
     **/
    public String copyOfAllLogs()
    {
        return "";
    }


    /**
     * Does nothing because nothing's ever recorded.
     **/
    public void clearLogs()
    {
    }
}

/* end-of-LogsRecorder.java */
