/**
 * $Id: ClearLoggedTask.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2003-2005 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx.capture;

import  com.idaremedia.antx.AntX;

/**
 * Helper task the clears the nearest {@linkplain LogsRecorder}. This task
 * is most often used to reset a top-level 
 * &lt;{@linkplain CaptureStreamsTask captureoutput}&gt;
 * so that the next &lt;copylogged&gt; captures a scoped subset of all generated output.
 * <p>
 * <b>Example Usage:</b><pre>
 *   &lt;captureoutput&gt;
 *      &lt;...<i>Some Tasks Here</i>&gt;
 *      &lt;copylogged from="stdio" important="no" tofile="..."/&gt;
 *      &lt;...<i>More Tasks Here</i>&gt;
 *      &lt;<b>clearlogged</b>/&gt;
 *      &lt;...<i>More Tasks Here</i>&gt;
 *      &lt;copylogged from="stdio" toproperty="..."/&gt;
 *   &lt;/captureoutput&gt;
 * </pre>
 *
 * @since    JWare/AntX 0.3
 * @author   ssmc, &copy;2003-2005 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  guarded
 * @.group   api,helper
 * @see      CaptureLogsTask
 * @see      CaptureStreamsTask
 **/

public final class ClearLoggedTask extends LogsUsingTask
{
    /**
     * Initializes a new ClearLoggedTask instance.
     **/
    public ClearLoggedTask()
    {
        this(AntX.capture+"ClearLoggedTask:");
    }


    /**
     * Initializes a CV-labeled ClearLoggedTask instance.
     * @param iam CV-label (non-null)
     **/
    public ClearLoggedTask(String iam)
    {
        super(iam);
        setReset(true);
        setImportant(false);
    }


    /**
     * Clears the current thread's nearest logs recorder (if one
     * is installed). Does nothing if there is no recorder.
     **/
    public void execute()
    {
        LogsRecorder r = getRecorder(true);
        if (r!=null) {
            r.clearLogs();
        }
    }
}

/* end-of-ClearLoggedTask.java */
