/**
 * $Id: AssertableLibDefinition.java 180 2007-03-15 12:56:38Z ssmc $
 * Copyright 2004 iDare Media, Inc. All rights reserved.
 *
 * Originally written by iDare Media, Inc. for release into the public domain. This
 * library, source form and binary form, is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License (LGPL) as published
 * by the Free Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.<p>
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU LGPL for more details.<p>
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite
 * 330, Boston, MA  02111-1307  USA. The GNU LGPL can be found online at
 * http://www.fsf.org/copyleft/lesser.html<p>
 *
 * This product has been influenced by several projects within the open-source community.
 * The JWare developers wish to acknowledge the open-source community's support. For more
 * information regarding the open-source products used within JWare, please visit the
 * JWare website.
 *----------------------------------------------------------------------------------------*
 * WEBSITE- http://www.jware.info                            EMAIL- inquiries@jware.info
 *----------------------------------------------------------------------------------------*
 **/

package com.idaremedia.antx;

import  org.apache.tools.ant.BuildException;
import  org.apache.tools.ant.Project;
import  org.apache.tools.ant.taskdefs.AntlibDefinition;

import  com.idaremedia.apis.UIStringManager;

import  com.idaremedia.antx.apis.AntLibFriendly;
import  com.idaremedia.antx.apis.ProjectDependent;
import  com.idaremedia.antx.apis.ScriptLocatable;
import  com.idaremedia.antx.helpers.Tk;

/**
 * Extension of basic Ant <i>AntlibDefinition</i> that adds builtin assertions. The
 * class's implementation is as it is because AntlibDefinition was made a class instead
 * of an interface (oye). Our definition is therefore, painfully redundant wrt
 * {@linkplain AssertableTask} but what can yah do&#8230;
 *
 * @since    JWare/AntX 0.4
 * @author   ssmc, &copy;2004 <a href="http://www.jware.info">iDare&nbsp;Media,&nbsp;Inc.</a>
 * @version  0.5
 * @.safety  single
 * @.group   api,infra
 * @.expects Ant 1.6
 **/

public abstract class AssertableLibDefinition extends AntlibDefinition
    implements ProjectDependent, ScriptLocatable, AntLibFriendly
{
    /**
     * Initializes new unlabeled definition task.
     **/
    protected AssertableLibDefinition()
    {
        super();
        Iam_="";
    }



    /**
     * Initializes new CV-labeled definition task.
     * @param iam CV-label (non-null)
     **/
    protected AssertableLibDefinition(String iam)
    {
        super();
        Iam_= Tk.cvlabelFrom(iam);
    }



    /**
     * Ensures this task's {@linkplain #initonce} method is called just
     * once. Sometimes Ant introspection mechanisms trigger mulitple calls
     * to init. This ensure that once-only initialization code is really
     * only called once.
     * @since JWare/AntX 0.5
     **/
    public void init()
    {
        super.init();

        if (!m_initedOnce) {
            initonce();
            m_initedOnce=true;
        }
    }



    /**
     * Initialization that must be done at most one time. Called by
     * {@linkplain #init} once even if init is itself called multiple
     * times.
     * @throws BuildException if unable to initialize required bits
     * @since JWare/AntX 0.5
     **/
    protected void initonce()
    {
    }




    /**
     * Ensures the verification method 
     * {@linkplain #verifyCanExecute_ verifyCanExecute_()} is called
     * before inherited execution.
     * @since JWare/AntX 0.5
     */
    public void execute()
    {
        verifyCanExecute_("exec");
        super.execute();
    }




    /**
     * Shortcut that returns this task's internal AntX UI strings manager.
     * Never returns <i>null</i>.
     * @see Iteration#uistrs
     **/
    public final UIStringManager uistrs()
    {
        return Iteration.uistrs();
    }


// ---------------------------------------------------------------------------------------
// (AntX) Universal Task Log Conversion (make events useful):
// ---------------------------------------------------------------------------------------

    /**
     * Indicate this task as source of logged message.
     **/
    public void log(String msg, int msgLevel)
    {
        if (getProject()!=null) {
            getProject().log(this,msg,msgLevel);
        } else {
            if (msgLevel >= Project.MSG_INFO) { //NB: works around bug in Task.log!
                System.err.println(msg);
            }
        }
    }

// ---------------------------------------------------------------------------------------
// (AntX) Universal Task Assertion Facilities:
// ---------------------------------------------------------------------------------------


    /**
     * Returns this task's CV-label. Never <i>null</i>.
     **/
    public final String cvlabel_()
    {
        return Iam_;
    }


    /**
     * Throws assertion error if pre-condtion is not met.
     * @param c pre-condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalArgumentException if condition not met
     **/
    protected final void require_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.require",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalArgumentException(ermsg);
        }
    }


    /**
     * Throws assertion error if post-condition is not met. Used
     * for post-condition verification.
     * @param c post-condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalStateException if condition not met
     **/
    protected final void ensure_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.ensure",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    /**
     * Throws assertion error if condition is not met. Used for
     * block and invariant verification.
     * @param c condition
     * @param msg [optional] failure message (if not met)
     * @throws IllegalStateException if condition not met
     **/
    protected final void verify_(boolean c, String msg)
    {
        if (!c) {
            String ermsg = uistrs().get("cv.verify",Iam_,msg);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    /**
     * Notes an unexpected but manageable problem has occured.
     * Just logs a warning by default.
     * @param t [optional] causing throwable
     * @param msg caller's additional (context) message
     **/
    protected final void unexpected_(Throwable t, String msg)
    {
        String ermsg = uistrs().get("cv.unexpected",Iam_,msg,t);
        log(ermsg, Project.MSG_WARN);
    }


    /**
     * Verifies we're in a live project (created from build process).
     * @throws IllegalStateException if not in project
     **/
    protected final void verifyInProject_(String calr)
    {
        if (getProject()==null) {
            String ermsg = uistrs().get("cv.verifyInP",Iam_,calr);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
    }


    /**
     * Verifies we're in a live target and project (created from
     * build process).
     * @throws IllegalStateException if not in target
     **/
    protected final void verifyInTarget_(String calr)
    {
        if (getOwningTarget()==null) {
            String ermsg = uistrs().get("cv.verifyInT",Iam_,calr);
            log(ermsg, Project.MSG_ERR);
            throw new IllegalStateException(ermsg);
        }
        verifyInProject_(calr);
    }


    /**
     * Called by '<i>execute</i>' on entry to verify that all required
     * options have been specified for correct execution of this task.
     * By default just verifies this task is associated with an enclosing
     * project.
     * @param calr calling method (usually 'execute' or 'run')
     * @throws IllegalStateException if improperly configured
     * @throws BuildException if unable to execute
     **/
    protected void verifyCanExecute_(String calr)
        throws BuildException
    {
        verifyInProject_(calr);
    }



    private final String Iam_;
    private boolean m_initedOnce;
}

/* end-of-AssertableLibDefinition.java */
