<?xml version="1.0"?>
<!--
  This schematron defines the rules used for the publish config file.

  @since 5.9900
-->
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">

  <sch:title>Publish config validation</sch:title>

  <!--
    Set of rules applying to the publish config
  -->
  <sch:pattern>
    <sch:title>Publish</sch:title>

    <sch:rule context="source">

      <!-- A 'source' element with type="document" must have an 'extension' attribute  -->
      <sch:assert test="not(@type='document') or @extension">A 'source' element with type="document" must have an 'extension' attribute.</sch:assert>

    </sch:rule>

    <sch:rule context="autosuggest">

      <!-- A 'autosuggest' element can only appear as a child of a 'param' with type 'document' or 'folder' -->
      <sch:assert test="parent::param[@type = 'document' or @type = 'folder']">The 'autosuggest' element can only appear as a child of a 'param' with type 'document' or 'folder'.</sch:assert>

    </sch:rule>

  </sch:pattern>

</sch:schema>