<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron"
						xmlns:old="antlib:com.pageseeder.external.ant"
            queryBinding="xslt2">
	<sch:ns prefix="old" uri="antlib:com.pageseeder.external.ant"/>
	<sch:ns prefix="extras" uri="antlib:org.jwaresoftware.antxtras"/>
	<sch:title>ANT scripts</sch:title>
	<sch:pattern name="Project">
		<sch:rule context="/project">
			<sch:assert test="not(//old:*)">
				The namespace "antlib:com.pageseeder.external.ant" is obsolete,
				use "antlib:com.pageseeder.publishapi.ant" instead.
			</sch:assert>
			<sch:assert test="not(//extras:* or
			    //taskdef[@resource='org/jwaresoftware/antxtras/antlib.xml'] or
			    //taskdef[@resource='org/jwaresoftware/antxtras/antlib-advanced.xml'])">
				The AntXtras library is obsolete, use standard or ant-contrib tasks instead.
			</sch:assert>
			<sch:assert test="not(//import[contains(@file,'/ant-library/')])">
				The import element containing '/ant-library/' is obsolete,
				use current Ant tasks instead.
			</sch:assert>
		</sch:rule>
	</sch:pattern>
	<sch:pattern name="Target">
		<sch:rule context="//target">
			<sch:assert test="not(.//*[local-name()='ps-download-xrefs'])">
				The ps-download-xrefs Ant task in target <sch:value-of select="@name"/> is obsolete,
				use export task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-download'])">
				The ps-download Ant task in target <sch:value-of select="@name"/> is obsolete,
				use export task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-http'])">
				The ps-http Ant task in target <sch:value-of select="@name"/> is obsolete,
				use standard Ant get task or Ant-Contrib post task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-insert-xlink-batch'])">
				The ps-insert-xlink-batch Ant task in target <sch:value-of select="@name"/> is obsolete,
				use request task and services instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-request'])">
				The ps-request Ant task in target <sch:value-of select="@name"/> is obsolete,
				use request task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-upload-delete'])">
				The ps-upload-delete Ant task in target <sch:value-of select="@name"/> is obsolete,
				use loadingzone-delete task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-upload-get'])">
				The ps-upload-get Ant task in target <sch:value-of select="@name"/> is obsolete,
				use loadingzone-get task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-upload-put'])">
				The ps-upload-put Ant task in target <sch:value-of select="@name"/> is obsolete,
				use loadingzone-put task instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='ps-upload'])">
				The ps-upload Ant task in target <sch:value-of select="@name"/> is obsolete,
				use upload task instead.
			</sch:assert>
			<sch:assert test="not(@depends='psinit.clean-working-folder')">
				The depends="psinit.clean-working-folder" attribute on target <sch:value-of select="@name"/> is obsolete
				and must be removed. It is no longer required.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='process']/*/@includes)">
				The process @includes attribute in target <sch:value-of select="@name"/> is obsolete,
				use include elements with @name instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='process']/*/@excludes)">
				The process @excludes attribute in target <sch:value-of select="@name"/> is obsolete,
				use exclude elements with @name instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='process']/@generatetoc)">
				The process/@generatetoc attribute in target <sch:value-of select="@name"/> is obsolete,
				use publication config instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='process']/xrefs/@levels)">
				The process/xrefs/@levels attribute in target <sch:value-of select="@name"/> is obsolete,
				use publication config instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='process']/number)">
				The process/number element in target <sch:value-of select="@name"/> is obsolete,
				use publication config instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='export']/@resolveimages)">
					The export/@resolveimages attribute in target <sch:value-of select="@name"/> is obsolete,
					use loadimages attribute instead.
			</sch:assert>
			<sch:assert test="not(.//*[local-name()='export']/@imagemetadataonly)">
					The export/@imagemetadataonly attribute in target <sch:value-of select="@name"/> is obsolete,
					use binarymetadataonly attribute instead.
			</sch:assert>
      <sch:assert test="not(.//*[local-name()='export-pdf']/config/@name)">
          The export-pdf/config/@name attribute in target <sch:value-of select="@name"/> is deprecated,
          it is no longer needed.
      </sch:assert>
      <sch:assert test="not(.//*[local-name()='export-pdf']/configs)">
          The export-pdf/configs element in target <sch:value-of select="@name"/> is deprecated,
          use config element instead.
      </sch:assert>
			<sch:assert test="not(script[lower-case(@language)='javascript' and contains(.,'replaceAll')])">
				A script element in target <sch:value-of select="@name"/> contains replaceAll which is not supported
				by Rhino used for Java 15 or higher. Use replace(/[regex]/g instead. For example change
				'project.getProperty("x").replaceAll(" ", "_")' to
				'var name = project.getProperty("x");
				... name.replace(/ /g, "_")'.
			</sch:assert>
		</sch:rule>
	</sch:pattern>
</sch:schema>