/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.generator.GeneratorErrors;
import com.pageseeder.layout.ui.LayoutServletRequest;
import com.pageseeder.layout.ui.LayoutServletResponse;
import com.pageseeder.layout.utils.UIXMLUtils;
import java.io.IOException;
import java.nio.CharBuffer;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletAdaptor
implements ContentGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServletAdaptor.class);
    private static final String PUBID = "publicationid";

    public void process(ContentRequest req, XMLWriter xml) throws BerliozException, IOException {
        String servletClassName = req.getParameter("servlet-class");
        ServletContext context = (ServletContext)req.getAttribute("com.pageseeder.layout.ui.ServletContext");
        assert (context != null);
        RequestDispatcher dispatcher = context.getNamedDispatcher(servletClassName);
        if (dispatcher == null) {
            xml.openElement("error");
            xml.attribute("id", GeneratorErrors.format((int)FrameworkErrorID.GENERATOR_NOT_FOUND.id()));
            xml.element("message", "Unable to find Servlet " + servletClassName);
            xml.closeElement();
            req.setStatus(ContentStatus.NOT_IMPLEMENTED);
        } else {
            req.setAttribute("com.pageseeder.layout", (Object)Boolean.TRUE);
            HttpContentRequest hr = (HttpContentRequest)req;
            LayoutServletRequest servletRequest = new LayoutServletRequest(hr.getHttpRequest());
            LayoutServletResponse servletResponse = new LayoutServletResponse(hr.getHttpResponse());
            Enumeration names = req.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = req.getParameter(name);
                assert (value != null);
                servletRequest.addParameter(name, value);
            }
            if (req.getParameter(PUBID) == null && hr.getHttpRequest().getParameter(PUBID) != null) {
                servletRequest.addParameter(PUBID, hr.getHttpRequest().getParameter(PUBID));
            }
            if ("com.pageseeder.Default".equals(servletClassName) && this.hasCompareParameter(req)) {
                servletRequest.addParameter("compare-diffx", "true");
            }
            try {
                dispatcher.include((ServletRequest)servletRequest, (ServletResponse)servletResponse);
                servletResponse.flushBuffer();
                ContentStatus status = ContentStatus.forCode((int)servletResponse.getStatus());
                if (status != null) {
                    req.setStatus(status);
                }
                for (Cookie ck : servletResponse.getCookies()) {
                    hr.getHttpResponse().addCookie(ck);
                }
                if (servletResponse.hasError()) {
                    if (servletResponse.getStatus() >= 500) {
                        throw new BerliozException(servletResponse.getMessage());
                    }
                    xml.openElement("error");
                    xml.attribute("id", GeneratorErrors.format((int)0));
                    xml.element("message", servletResponse.getMessage());
                    xml.closeElement();
                }
                CharBuffer cb = servletResponse.getCharBuffer();
                cb = UIXMLUtils.removeXMLDeclaration(cb);
                if ((cb = UIXMLUtils.removeDoctypes(cb)) != null) {
                    xml.writeXML(cb.array(), cb.position(), cb.remaining());
                }
            }
            catch (Exception ex) {
                LOGGER.error("An error occurred while invoking servlet", (Throwable)ex);
                req.setAttribute("javax.servlet.error.exception", (Object)ex);
                req.setAttribute("javax.servlet.error.exception_type", ex.getClass());
                req.setStatus(ContentStatus.INTERNAL_SERVER_ERROR);
                throw new BerliozException("Error thrown by servlet", ex);
            }
        }
    }

    private boolean hasCompareParameter(ContentRequest req) {
        return !req.getParameter("compare", "").isEmpty() || !req.getParameter("compareid", "").isEmpty();
    }
}

