/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout.ui;

import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.UnforeseenException;
import com.pageseeder.common.util.CollectedError;
import com.pageseeder.common.util.CollectingException;
import com.pageseeder.common.util.ISO8601;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.servlet.ErrorHandlerServlet;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;

public class GetErrorDetails
implements ContentGenerator {
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        HttpServletRequest request = ((HttpContentRequest)req).getHttpRequest();
        try {
            Integer status = (Integer)req.getAttribute("javax.servlet.error.status_code");
            String message = (String)req.getAttribute("javax.servlet.error.message");
            String uri = (String)req.getAttribute("javax.servlet.error.request_uri");
            String servlet = (String)req.getAttribute("javax.servlet.error.servlet_name");
            Throwable error = (Throwable)req.getAttribute("javax.servlet.error.exception");
            if (error == null) {
                error = (Throwable)req.getAttribute("com.pageseeder.error.exception");
            }
            if (uri == null) {
                uri = request.getRequestURI();
            }
            if (error != null) {
                LoggerFactory.getLogger(ErrorHandlerServlet.class).error("Error caught by handler", error);
            }
            xml.element("http-code", status != null ? status.toString() : "200");
            xml.element("http-method", request.getMethod());
            xml.element("message", message);
            xml.element("request-uri", uri);
            xml.element("servlet", servlet != null ? servlet : "");
            xml.element("datetime", ISO8601.now());
            xml.element("host", Objects.toString(request.getHeader("host"), ""));
            xml.element("user-agent", Objects.toString(request.getHeader("user-agent"), ""));
            String referer = request.getHeader("referer");
            if (referer != null) {
                xml.element("referer", referer);
            }
            this.writeStackTrace(xml, error);
            this.writeCollectedErrors(xml, error);
        }
        catch (ClassCastException ex) {
            throw new UnforeseenException((Throwable)ex);
        }
    }

    private void writeStackTrace(XMLWriter xml, @Nullable Throwable error) throws IOException {
        if (error != null) {
            xml.openElement("stacktrace");
            String stacktrace = WebUtilities.getStackTrace((Throwable)error, (boolean)true);
            xml.writeText(stacktrace);
            xml.closeElement();
        }
    }

    private void writeCollectedErrors(XMLWriter xml, @Nullable Throwable error) throws IOException {
        if (error instanceof CollectingException) {
            List collected = ((CollectingException)error).collected();
            xml.openElement("collected-errors");
            for (CollectedError c : collected) {
                CollectedError.Level level = c.level();
                Exception exception = c.error();
                xml.openElement("error", true);
                xml.attribute("level", level.toString());
                if (exception instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)exception;
                    String systemId = spe.getSystemId();
                    if (systemId.contains("WEB-INF")) {
                        systemId = systemId.substring(systemId.indexOf("WEB-INF") + 7);
                    }
                    xml.attribute("line", Integer.toString(spe.getLineNumber()));
                    xml.attribute("column", Integer.toString(spe.getColumnNumber()));
                    xml.attribute("location", systemId);
                }
                xml.element("message", exception.getMessage());
                xml.closeElement();
            }
            xml.closeElement();
        }
    }
}

