/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.layout;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.AccessLogger;
import com.pageseeder.base.logback.TicketLog;
import com.pageseeder.base.logback.XLoggerAdaptor;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import java.io.IOException;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"ticket"})
public final class GetTicketLog
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        String groupid = req.getParameter((Parameter)StandardParameters.index);
        if (groupid == null || "true".equals(req.getParameter((Parameter)StandardParameters.admin))) {
            return new AdminSystemCheck();
        }
        try {
            return new EditURICheck(DatabaseQuery.getGroupById((Database)req.getDatabase(), (Long)Long.parseLong(groupid)));
        }
        catch (QueryFailedException ex) {
            req.getLogger((Object)this).error("Failed to load group {}", (Object)groupid, (Object)ex);
            return new ForbiddenCheck();
        }
    }

    public void process(GeneratorRequest req, GeneratorResponse res) {
        List methods;
        long groupid = req.getParameter((Parameter)StandardParameters.groupid, -1L);
        String ticket = req.getParameter((Parameter)StandardParameters.ticket);
        String date = req.getParameter((Parameter)StandardParameters.date);
        String from = req.getParameter((Parameter)StandardParameters.from);
        String to = req.getParameter((Parameter)StandardParameters.to);
        long page = req.getParameter((Parameter)StandardParameters.page, -1L);
        long pagesize = req.getParameter((Parameter)StandardParameters.pagesize, -1L);
        boolean singleDay = req.getParameter((Parameter)StandardParameters.single_day, true);
        boolean includeInfo = req.getParameter((Parameter)StandardParameters.include_info, true);
        String[] includeTypes = req.getParameter((Parameter)StandardParameters.include_types, "").split(",");
        String permission = req.getParameter((Parameter)StandardParameters.permissions, "").toLowerCase().trim();
        List permissions = permission.isEmpty() ? Collections.emptyList() : Arrays.asList(permission.split(","));
        String method = req.getParameter((Parameter)StandardParameters.methods, "").toLowerCase().trim();
        List<Object> list = methods = method.isEmpty() ? Collections.emptyList() : Arrays.asList(method.split(","));
        assert (ticket != null);
        try {
            TicketLog log = new TicketLog((XLoggerAdaptor)AccessLogger.getInstance(), ticket, groupid < 0L ? null : Long.valueOf(groupid), null);
            log.setAccessLogs(!req.getParameter("by-group", false));
            if (!includeInfo) {
                log.addExcludeType("INFO");
            }
            for (String type : includeTypes) {
                if (type.isEmpty()) continue;
                log.addIncludeType(type);
            }
            log.setMultipleDays(!singleDay);
            if (page > 0L || pagesize > 0L) {
                log.setPagination((int)page, (int)pagesize);
            }
            if (date != null && !"today".equals(date)) {
                log.setDate(date);
            }
            log.setLimits(GetTicketLog.getDateTime(from, date), GetTicketLog.getDateTime(to, date));
            log.setPermissions(permissions);
            log.setMethods(methods);
            XMLWriter xml = res.getXMLWriter();
            log.toXML(xml);
            xml.flush();
        }
        catch (ParseException ex) {
            req.getLogger((Object)this).error("Could not parse date", (Throwable)ex);
            res.setError(GeneratorStatus.BAD_REQUEST, "Unparseable date '" + date + "'");
        }
        catch (IOException ex) {
            req.getLogger((Object)this).error("Unable to load log file", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
        }
    }

    private static @Nullable LocalDateTime getDateTime(@Nullable String param, @Nullable String date) throws ParseException {
        if (param == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date != null && !"today".equals(date) ? ISO8601.parseAuto((String)date) : new Date());
        return LocalDateTime.of(LocalDate.of(calendar.get(1), calendar.get(2) + 1, calendar.get(5)), LocalTime.parse(param));
    }
}

