/*
 * Decompiled with CFR 0.152.
 */
package net.pageseeder.ai.prompt;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import net.pageseeder.ai.prompt.BinaryContent;
import net.pageseeder.ai.util.MediaTypes;
import org.eclipse.jdt.annotation.Nullable;

public class FileContent
extends BinaryContent
implements Serializable {
    private final File file;
    private final String mediaType;
    private transient byte @Nullable [] bytes;

    FileContent(File file) {
        this.file = file;
        this.mediaType = MediaTypes.forFilename(file.getName());
    }

    @Override
    public String mediaType() {
        return this.mediaType;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public byte[] getBytes() {
        if (this.bytes != null) {
            return this.bytes;
        }
        try {
            this.bytes = Files.readAllBytes(this.file.toPath());
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return this.bytes;
    }

    public String toString() {
        return "FileContent{" + this.mediaType + ", file=" + String.valueOf(this.file) + "'}";
    }
}

