/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.job;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.common.util.ISO8601;
import java.io.Serializable;
import java.util.Collection;

public class Job
implements Serializable,
UniversallyPrintable {
    private static final long serialVersionUID = 1L;
    private final Long id;
    private final Long webhoookID;
    private final Collection<String> events;
    private final long retryDateTime;
    private final int retryNumber;

    protected Job(Long id, Long whid, Collection<String> evts) {
        this(id, whid, evts, -1L, 0);
    }

    private Job(Long id, Long whid, Collection<String> evts, long retryNext, int retryNb) {
        this.id = id;
        this.webhoookID = whid;
        this.events = evts;
        this.retryDateTime = retryNext;
        this.retryNumber = retryNb;
    }

    public Job increaseRetries() {
        long delay = (long)(Math.pow(2.0, this.retryNumber) * 10.0 * 1000.0);
        long retryNext = System.currentTimeMillis() + delay;
        int retryNb = this.retryNumber + 1;
        return new Job(this.id, this.webhoookID, this.events, retryNext, retryNb);
    }

    public Long getID() {
        return this.id;
    }

    public Collection<String> getEvents() {
        return this.events;
    }

    public Long getWebhoookID() {
        return this.webhoookID;
    }

    public long getRetryDateTime() {
        return this.retryDateTime;
    }

    public int getRetryNumber() {
        return this.retryNumber;
    }

    public void print(OutputPrinter out) {
        out.startObject("job");
        out.field("id", this.id.longValue());
        out.field("webhook", String.valueOf(this.webhoookID));
        if (this.retryNumber > 0) {
            out.field("retries", (long)this.retryNumber);
        }
        if (this.retryDateTime > 0L) {
            out.field("retry-next", ISO8601.DATETIME.format(this.retryDateTime));
        }
        out.field("events", this.events.toArray(new String[this.events.size()]));
        out.endObject();
    }
}

