/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.webhook.event.EventsCache;
import com.pageseeder.webhook.job.JobsQueue;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventsCleanupThread
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventsCleanupThread.class);
    private static boolean shouldStop = false;
    private final EventsCache cache;
    private final JobsQueue queue;
    private static final int DELAY_MS = 1800000;

    public EventsCleanupThread(EventsCache cache, JobsQueue queue) {
        this.cache = cache;
        this.queue = queue;
    }

    @Override
    public void run() {
        do {
            try {
                Long last = this.cache.getLastProcessedTimestamp();
                Collection<String> ids = this.queue.getAllEventIDs();
                this.cache.removeEventsWithoutID(ids, last);
            }
            catch (Throwable ex) {
                LOGGER.error("Webhook cleanup thread error", ex);
            }
            try {
                Thread.sleep(1800000L);
            }
            catch (InterruptedException ex) {
                if (shouldStop) continue;
                LOGGER.warn("Events thread interrupted, closing!");
                break;
            }
        } while (!shouldStop);
    }

    public static void stop() {
        shouldStop = true;
    }
}

