/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.webhook.event;

import com.pageseeder.base.serial.JSONOutputPrinter;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalHolder;
import com.pageseeder.base.serial.UniversallyPrintable;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.model.Webhook;
import com.pageseeder.webhook.event.EventAction;
import com.pageseeder.webhook.event.EventBuilder;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.LoggerFactory;

public class Event
implements Serializable,
UniversallyPrintable {
    private static final long serialVersionUID = 1L;
    private static final String DOT = ".";
    private final long timestamp;
    private final String id;
    private final String objectName;
    private final EventAction action;
    private final Long objectID;
    private final @Nullable String publicObjectID;
    private final @Nullable String publicObjectID2;
    private final @Nullable Collection<EventGroup> groups;
    private final @Nullable UniversalHolder output;
    private boolean queued;

    protected Event(EventBuilder builder) {
        assert (builder.getObjectID() != null);
        this.timestamp = builder.getTimestamp();
        this.objectID = builder.getObjectID();
        this.id = this.objectID + DOT + System.nanoTime();
        this.publicObjectID = builder.getPublicObjectID();
        this.publicObjectID2 = builder.getPublicObjectID2();
        this.objectName = builder.getObjectName();
        this.action = builder.getAction();
        this.output = builder.getOutput();
        this.groups = builder.getGroups() == null ? null : new ArrayList<EventGroup>(builder.getGroups());
    }

    private Event(Event e) {
        this.action = e.action;
        this.output = e.output;
        this.groups = e.groups;
        this.id = e.id;
        this.objectID = e.objectID;
        this.objectName = e.objectName;
        this.publicObjectID = e.publicObjectID;
        this.publicObjectID2 = e.publicObjectID2;
        this.timestamp = e.timestamp;
        this.queued = false;
    }

    protected Event cloneQueued() {
        Event cloned = new Event(this);
        cloned.queued = true;
        return cloned;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public String getID() {
        return this.id;
    }

    public Long getObjectID() {
        return this.objectID;
    }

    public @Nullable String getPublicObjectID() {
        return this.publicObjectID;
    }

    public boolean isPing() {
        return this.action == EventAction.ping;
    }

    public String getEventType() {
        return this.objectName + DOT + this.action.name();
    }

    public @Nullable Collection<EventGroup> getEventGroups() {
        return this.groups;
    }

    public void print(OutputPrinter out, @Nullable Webhook webhook) {
        out.startObject("webevent");
        out.field("id", this.id);
        out.field("datetime", ISO8601.DATETIME.format(this.timestamp));
        out.field("type", this.getEventType());
        if (webhook == null) {
            out.field("queued", this.queued);
        }
        ArrayList<EventGroup> myGroups = new ArrayList<EventGroup>();
        if (this.groups != null) {
            for (EventGroup group : this.groups) {
                if (webhook != null && !webhook.includeGroup(group.name)) continue;
                myGroups.add(group);
            }
        }
        if (!myGroups.isEmpty()) {
            out.startCollection("event");
            for (EventGroup group : myGroups) {
                group.print(out);
            }
            out.endCollection();
        }
        if ((webhook == null || webhook.getObject() == Webhook.ObjectType.basic) && this.output != null) {
            this.output.print(out);
        } else if ("groupproperties".equals(this.objectName)) {
            out.startObject("properties");
            out.endObject();
        } else if (!"server".equals(this.objectName)) {
            String name;
            out.startObject(this.objectName);
            if (!"publication".equals(this.objectName)) {
                out.field("id", this.objectID.longValue());
            }
            if (this.publicObjectID != null) {
                name = this.toPublicIDName();
                if (name == null) {
                    LoggerFactory.getLogger(Event.class).error("No public ID name for object {}", (java.lang.Object)this.objectName);
                } else {
                    out.field(name, this.publicObjectID);
                }
            }
            if (this.publicObjectID2 != null) {
                name = this.toPublicID2Name();
                if (name == null) {
                    LoggerFactory.getLogger(Event.class).error("No public ID 2 name for object {}", (java.lang.Object)this.objectName);
                } else {
                    out.field(name, this.publicObjectID2);
                }
            }
            out.endObject();
        }
        out.endObject();
    }

    public int getBytes(Webhook webhook) {
        XMLOutputPrinter out = webhook.getFormat() == Webhook.Format.xml ? new XMLOutputPrinter() : new JSONOutputPrinter();
        this.print((OutputPrinter)out);
        return out.toString().getBytes(StandardCharsets.UTF_8).length;
    }

    public void print(OutputPrinter out) {
        this.print(out, null);
    }

    private @Nullable String toPublicIDName() {
        switch (this.objectName) {
            case "uri": {
                return "docid";
            }
            case "publication": {
                return "id";
            }
            case "member": {
                return "username";
            }
            case "groupfolder": {
                return "path";
            }
            case "group": 
            case "project": 
            case "webhook": {
                return "name";
            }
        }
        return null;
    }

    private @Nullable String toPublicID2Name() {
        if ("uri".equals(this.objectName)) {
            return "path";
        }
        if ("member".equals(this.objectName)) {
            return "email";
        }
        return null;
    }

    public static final class EventGroup
    implements Serializable,
    UniversallyPrintable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final Long id;

        public EventGroup(Long id, String name) {
            this.id = Objects.requireNonNull(id);
            this.name = Objects.requireNonNull(name);
        }

        public String name() {
            return this.name;
        }

        public void print(OutputPrinter out) {
            out.startObject("group");
            out.field("id", this.id.longValue());
            out.field("name", this.name);
            out.endObject();
        }
    }

    public static enum Object {
        uri,
        comment,
        task,
        workflow,
        group,
        groupfolder,
        groupproperties,
        membership,
        member,
        project,
        publication,
        webhook,
        server;

    }
}

