/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.pageseeder.psml.toc.DocumentTitle;
import org.pageseeder.psml.toc.Element;
import org.pageseeder.psml.toc.Part;
import org.pageseeder.psml.toc.Phantom;

public final class TreeExpander {
    private final Deque<MutablePart> _parts = new ArrayDeque<MutablePart>();

    public TreeExpander(String title) {
        this._parts.push(new MutablePart(new DocumentTitle(title)));
    }

    public TreeExpander() {
        this._parts.push(new MutablePart(DocumentTitle.UNTITLED));
    }

    public TreeExpander addLeaf(Element element) {
        MutablePart current = this._parts.peek();
        MutablePart mutable = new MutablePart(element);
        if (current != null) {
            current.add(mutable);
        }
        return this;
    }

    public TreeExpander add(Element element) {
        return this.add(element, element.level());
    }

    public TreeExpander add(Element element, int elementlevel) {
        int level = this._parts.size();
        MutablePart current = this._parts.peek();
        if (current == null) {
            current = new MutablePart(DocumentTitle.UNTITLED);
            this._parts.push(current);
        }
        while (elementlevel > level) {
            Phantom phantom = new Phantom(level++, element.fragment(), element.originalFragment());
            MutablePart mutable = new MutablePart(phantom);
            current.add(mutable);
            this._parts.push(mutable);
            current = mutable;
        }
        while (elementlevel < level) {
            this._parts.pop();
            current = this._parts.peek();
            --level;
        }
        MutablePart mutable = new MutablePart(element);
        if (current != null) {
            current.add(mutable);
        }
        this._parts.push(mutable);
        return this;
    }

    public List<Part<?>> parts() {
        MutablePart root = this._parts.peekLast();
        if (root == null) {
            throw new IllegalStateException("No root!");
        }
        Part<?> document = root.build();
        return document.parts();
    }

    private static class MutablePart {
        private final Element _element;
        private final List<MutablePart> _parts = new ArrayList<MutablePart>();

        public MutablePart(Element element) {
            this._element = element;
        }

        public void add(MutablePart part) {
            this._parts.add(part);
        }

        public Part<?> build() {
            @NonNull Part[] parts = (Part[])this._parts.stream().map(p -> p.build()).toArray(Part[]::new);
            return new Part<Element>(this._element, parts);
        }
    }
}

