/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.toc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.PublicationNumbering;
import org.pageseeder.psml.toc.TitleCollapse;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PublicationConfig
implements Cloneable {
    private TitleCollapse tocTitleCollapse = TitleCollapse.always;
    private String tocParaIndents = ",";
    private String tocBlockLabels = ",";
    private LevelRelativeTo xrefLevelRelativeTo = LevelRelativeTo.HEADING;
    private LevelRelativeTo paraLevelRelativeTo = LevelRelativeTo.HEADING;
    private LevelAdjust paraLevelAdjust = LevelAdjust.NUMBERING;
    private LevelAdjust headingLevelAdjust = LevelAdjust.NUMBERING;
    private List<PublicationNumbering> numberingConfigs = new ArrayList<PublicationNumbering>();

    public PublicationConfig clone() {
        try {
            return (PublicationConfig)super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setTocTitleCollapse(TitleCollapse tocTitleCollapse) {
        this.tocTitleCollapse = tocTitleCollapse;
    }

    public void setTocParaIndents(String tocParaIndents) {
        this.tocParaIndents = (tocParaIndents == null ? "" : tocParaIndents) + ",";
    }

    public void setTocBlockLabels(String tocBlockLabels) {
        this.tocBlockLabels = (tocBlockLabels == null ? "" : tocBlockLabels) + ",";
    }

    public void setXrefLevelRelativeTo(LevelRelativeTo xrefLevelRelativeTo) {
        if (xrefLevelRelativeTo.getLevel() > 0) {
            throw new IllegalArgumentException("Numbers are not allowed");
        }
        this.xrefLevelRelativeTo = xrefLevelRelativeTo;
    }

    public void setParaLevelRelativeTo(LevelRelativeTo paraLevelRelativeTo) {
        this.paraLevelRelativeTo = paraLevelRelativeTo;
    }

    public void setParaLevelAdjust(LevelAdjust paraLevelAdjust) {
        this.paraLevelAdjust = paraLevelAdjust;
    }

    public void setHeadingLevelAdjust(LevelAdjust headingLevelAdjust) {
        this.headingLevelAdjust = headingLevelAdjust;
    }

    public void setNumberingConfigs(List<PublicationNumbering> numberingConfigs) {
        this.numberingConfigs = numberingConfigs;
    }

    public List<PublicationNumbering> getNumberingConfigs() {
        return this.numberingConfigs;
    }

    public @Nullable PublicationNumbering getPublicationNumbering(String labels) {
        String[] ls = labels.split(",");
        PublicationNumbering def = null;
        for (PublicationNumbering config : this.numberingConfigs) {
            for (String label : ls) {
                if (!label.equals(config.getLabel())) continue;
                return config;
            }
            if (!"".equals(config.getLabel()) || def != null) continue;
            def = config;
        }
        return def;
    }

    public static PublicationConfig loadPublicationConfigFile(File configFile) throws IOException {
        if (!configFile.exists() || !configFile.isFile()) {
            throw new IOException("Publication config file not found: " + configFile.getAbsolutePath());
        }
        try {
            return PublicationConfig.loadPublicationConfig(new FileInputStream(configFile));
        }
        catch (FileNotFoundException ex) {
            throw new IOException("Publication config file not found: " + configFile.getAbsolutePath());
        }
    }

    public static PublicationConfig loadPublicationConfig(InputStream in) throws IOException {
        PublicationConfigHandler handler = new PublicationConfigHandler();
        PublicationConfig.parse(in, handler);
        return handler.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputStream in, ContentHandler handler) throws IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            XMLReader reader = factory.newSAXParser().getXMLReader();
            reader.setContentHandler(handler);
            try {
                reader.parse(new InputSource(in));
            }
            finally {
                in.close();
            }
        }
        catch (SAXException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
        catch (ParserConfigurationException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    public TitleCollapse getTocTitleCollapse() {
        return this.tocTitleCollapse;
    }

    public String getTocParaIndents() {
        return this.tocParaIndents;
    }

    public String getTocBlockLabels() {
        return this.tocBlockLabels;
    }

    public LevelRelativeTo getXRefLevelRelativeTo() {
        return this.xrefLevelRelativeTo;
    }

    public LevelRelativeTo getParaLevelRelativeTo() {
        return this.paraLevelRelativeTo;
    }

    public LevelAdjust getParaLevelAdjust() {
        return this.paraLevelAdjust;
    }

    public LevelAdjust getHeadingLevelAdjust() {
        return this.headingLevelAdjust;
    }

    private static class PublicationConfigHandler
    extends DefaultHandler {
        private PublicationConfig config = null;
        private PublicationNumbering numbering = null;

        private PublicationConfigHandler() {
        }

        public PublicationConfig getConfig() {
            return this.config;
        }

        @Override
        public void startDocument() throws SAXException {
            this.config = new PublicationConfig();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if ("toc".equals(qName)) {
                this.config.tocTitleCollapse = TitleCollapse.fromString(attributes.getValue("title-collapse"));
                this.config.setTocParaIndents(attributes.getValue("para-indents"));
                this.config.setTocBlockLabels(attributes.getValue("block-labels"));
            } else if ("levels".equals(qName)) {
                this.config.xrefLevelRelativeTo = LevelRelativeTo.fromString(attributes.getValue("xref-relative-to"));
                if (this.config.xrefLevelRelativeTo.getLevel() > 0) {
                    this.config.xrefLevelRelativeTo = LevelRelativeTo.HEADING;
                }
                this.config.paraLevelRelativeTo = LevelRelativeTo.fromString(attributes.getValue("para-relative-to"));
                this.config.paraLevelAdjust = LevelAdjust.fromString(attributes.getValue("para-adjust"));
                this.config.headingLevelAdjust = LevelAdjust.fromString(attributes.getValue("heading-adjust"));
            } else if ("numbering".equals(qName)) {
                this.numbering = new PublicationNumbering();
                this.numbering.setSkippedLevels(PublicationNumbering.SkippedLevels.fromString(attributes.getValue("skipped-levels")));
                String label = attributes.getValue("document-label");
                if (label != null) {
                    this.numbering.setLabel(label);
                }
            } else {
                if ("scheme".equals(qName) && this.numbering != null) {
                    try {
                        int level = Integer.parseInt(attributes.getValue("level"));
                        if (level < 1 || level > 9) {
                            new SAXException("Invalid level: " + level);
                        }
                        this.numbering.addNumberType(level, attributes.getValue("block-label"), attributes.getValue("type"));
                        this.numbering.addNumberFormat(level, attributes.getValue("block-label"), attributes.getValue("format"));
                        this.numbering.addElement(level, attributes.getValue("block-label"), attributes.getValue("element"));
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException("Invalid level: " + attributes.getValue("level"));
                    }
                }
                if ("restart".equals(qName) && this.numbering != null) {
                    try {
                        int level = Integer.parseInt(attributes.getValue("level"));
                        if (level < 1 || level > 9) {
                            new SAXException("Invalid level: " + level);
                        }
                        this.numbering.addRestart(level, attributes.getValue("block-label"));
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException("Invalid level: " + attributes.getValue("level"));
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("numbering".equals(qName)) {
                this.config.numberingConfigs.add(this.numbering);
            }
        }
    }

    public static enum LevelAdjust {
        NUMBERING,
        CONTENT;


        public static LevelAdjust fromString(String value) {
            for (LevelAdjust n : LevelAdjust.values()) {
                if (!n.name().toLowerCase().equals(value)) continue;
                return n;
            }
            return NUMBERING;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum LevelRelativeTo {
        HEADING(-2),
        DOCUMENT(-1),
        FIVE(5),
        SIX(6),
        SEVEN(7),
        EIGHT(8),
        NINE(9);

        private final int level;

        private LevelRelativeTo(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public static LevelRelativeTo fromString(String value) {
            if ("document".equals(value)) {
                return DOCUMENT;
            }
            for (LevelRelativeTo n : LevelRelativeTo.values()) {
                if (!Integer.toString(n.level).equals(value)) continue;
                return n;
            }
            return HEADING;
        }
    }
}

