/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Map;
import org.pageseeder.psml.template.ParameterType;
import org.pageseeder.psml.template.Token;
import org.pageseeder.psml.template.XML;

class TValue
implements Token {
    private final String name;
    private final ParameterType type;
    private final String fallback;
    private final boolean attribute;

    public TValue(String name, String fallback, ParameterType type, boolean attribute) {
        this.name = name;
        this.fallback = fallback;
        this.type = type;
        this.attribute = attribute;
    }

    @Override
    public void print(PrintWriter psml, Map<String, String> values, Charset charset) {
        String value = values.get(this.name);
        if (value != null) {
            if (!this.type.matches(value)) {
                value = this.fallback;
            }
        } else {
            value = this.fallback;
        }
        if (this.type == ParameterType.XML) {
            psml.print(value);
        } else {
            XML.Encoder encoder = XML.getEncoder(charset);
            StringBuilder xml = new StringBuilder();
            if (this.attribute) {
                encoder.attribute(value, xml);
            } else {
                encoder.text(value.toCharArray(), 0, value.length(), xml);
            }
            psml.print(xml.toString());
        }
    }
}

