/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.template.ParameterType;
import org.pageseeder.psml.template.TData;
import org.pageseeder.psml.template.TError;
import org.pageseeder.psml.template.TValue;
import org.pageseeder.psml.template.Token;

final class TFragment {
    private final String kind;
    private final String type;
    private final @Nullable String mediatype;
    private final List<Token> tokens;

    private TFragment(Builder builder) {
        assert (builder.kind != null);
        this.kind = builder.kind;
        this.type = builder.type;
        this.mediatype = builder.mediatype;
        this.tokens = new ArrayList<Token>(builder.tokens);
    }

    public String kind() {
        return this.kind;
    }

    public String type() {
        return this.type;
    }

    public @Nullable String mediatype() {
        return this.mediatype;
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    protected static final class Builder {
        private final String type;
        private @Nullable String kind;
        private @Nullable String mediatype;
        private final Map<String, ParameterType> types = new HashMap<String, ParameterType>();
        private final Map<String, String> defaults = new HashMap<String, String>();
        private final List<Token> tokens = new ArrayList<Token>();

        public Builder(String type) {
            this.type = Objects.requireNonNull(type, "Fragment type is required");
        }

        public void setKind(String kind) {
            this.kind = kind;
        }

        public void setMediatype(@Nullable String mediatype) {
            this.mediatype = mediatype;
        }

        public void addParameter(String name, @Nullable String fallback, ParameterType type) {
            this.types.put(name, type);
            if (fallback != null) {
                this.defaults.put(name, fallback);
            }
        }

        public void pushValue(String name, boolean attribute) {
            ParameterType paramType = this.types.getOrDefault(name, ParameterType.TEXT);
            String fallback = this.defaults.getOrDefault(name, "");
            this.tokens.add(new TValue(name, fallback, paramType, attribute));
        }

        public void pushData(String data) {
            this.tokens.add(new TData(data));
        }

        public TFragment build() {
            if (this.kind == null) {
                this.kind = "fragment";
                this.tokens.add(new TError("fragment definition does not include fragment"));
            }
            return new TFragment(this);
        }
    }
}

