/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.template;

import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.pageseeder.psml.template.Token;
import org.pageseeder.psml.template.XML;

final class TData
implements Token {
    private final String data;
    private final boolean hasNonASCIIChar;

    public TData(String data) {
        this.data = Objects.requireNonNull(data);
        this.hasNonASCIIChar = XML.hasNonASCIIChar(data);
    }

    @Override
    public void print(PrintWriter psml, Map<String, String> values, Charset charset) {
        if (this.hasNonASCIIChar && charset.equals(StandardCharsets.US_ASCII)) {
            XML.toASCII(this.data, psml);
        } else {
            psml.print(this.data);
        }
    }
}

