/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.NumberedTOCGenerator;
import org.pageseeder.psml.process.PSMLProcessHandler;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.TransclusionHandler;
import org.pageseeder.psml.process.math.TexConverter;
import org.pageseeder.psml.process.util.Files;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.toc.DocumentTree;
import org.pageseeder.psml.toc.DocumentTreeHandler;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XRefTranscluder {
    public static final int MAX_DEPTH = 50;
    public static final int WARNING_DEPTH = 10;
    private final PSMLProcessHandler parentHandler;
    private final Map<File, List<String>> parentFiles = new HashMap<File, List<String>>();
    final List<String> xrefsTranscludeTypes = new ArrayList<String>();
    boolean excludeXRefFragment = false;
    boolean onlyXRefFrament = false;
    private boolean transcludeImages = false;
    private boolean transcludeLinks = false;
    private boolean isTranscluding = false;

    public XRefTranscluder(PSMLProcessHandler dad) {
        this.parentHandler = dad;
    }

    public void addXRefsTypes(@Nullable List<String> xrefTypes) {
        if (xrefTypes != null) {
            this.xrefsTranscludeTypes.addAll(xrefTypes);
            this.isTranscluding = true;
        }
    }

    public void setXRefFragmentHandling(boolean exclude, boolean only) {
        this.excludeXRefFragment = exclude;
        this.onlyXRefFrament = only;
    }

    public void setTranscludeImages(boolean transclude) {
        this.transcludeImages = transclude;
    }

    public void setTranscludeLinks(boolean transclude) {
        this.transcludeLinks = transclude;
    }

    public boolean isTranscluding() {
        return this.isTranscluding;
    }

    public void addParentFile(@Nullable File parent, @Nullable String fragment) {
        if (parent != null && fragment != null) {
            List<String> fragments = this.parentFiles.get(parent);
            if (fragments == null) {
                fragments = new ArrayList<String>();
            }
            if (fragments.contains(fragment)) {
                throw new IllegalStateException("Should not be here: adding an existing fragment as a parent file");
            }
            fragments.add(fragment);
            this.parentFiles.put(parent, fragments);
        }
    }

    public boolean isNotFoundXRef(String href) {
        File target = this.findXRefTarget(href, null, false);
        return target == null || !target.exists() || !target.isFile();
    }

    public boolean transcludeXRef(Attributes atts, boolean inXrefFragment, boolean image, boolean link, boolean inEmbedHierarchy, boolean convertTex) throws ProcessException {
        boolean transclude;
        if (!image && !link && (inXrefFragment && this.excludeXRefFragment || !inXrefFragment && this.onlyXRefFrament)) {
            return false;
        }
        String href = atts.getValue(image ? "src" : "href");
        String type = image ? "image" : (link ? "link" : atts.getValue("type"));
        String uriid = atts.getValue("uriid");
        boolean bl = image ? this.transcludeImages : (transclude = link ? this.transcludeLinks : this.xrefsTranscludeTypes.contains(type));
        if (transclude && !"true".equals(atts.getValue("external")) && !"true".equals(atts.getValue("unresolved")) && uriid != null) {
            boolean mathTarget;
            File target = this.findXRefTarget(href, uriid, link);
            if (target == null || !target.exists() || !target.isFile()) {
                throw new XRefNotFoundException();
            }
            boolean bl2 = mathTarget = "math".equalsIgnoreCase(type) && "default".equals(atts.getValue("frag"));
            if (!((mathTarget || target.getName().endsWith(".psml")) && (!mathTarget || target.getName().endsWith(".mml") || target.getName().endsWith(".mathml") || convertTex && target.getName().endsWith(".tex")))) {
                return false;
            }
            if (this.parentFiles.size() > 50) {
                throw new TooDeepException();
            }
            if (this.parentFiles.size() > 10) {
                String tgt;
                String src;
                try {
                    src = this.parentHandler.getSourceFile().getCanonicalPath().substring(this.parentHandler.getPSMLRoot().getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
                    tgt = target.getCanonicalPath().substring(this.parentHandler.getPSMLRoot().getCanonicalPath().length() + 1).replace(File.separatorChar, '/');
                }
                catch (IOException e) {
                    src = this.parentHandler.getSourceFile().getName();
                    tgt = href;
                }
                this.parentHandler.getLogger().warn("Transclusion/embed depth is suspiciously high (> 10) for XRef from {} to {}.", (Object)src, (Object)tgt);
            }
            if (mathTarget) {
                try {
                    this.parentHandler.write("<media-fragment id=\"media\" mediatype=\"application/mathml+xml\">");
                    if (convertTex && target.getName().endsWith(".tex")) {
                        try {
                            this.parentHandler.write(TexConverter.convert(String.join((CharSequence)"", java.nio.file.Files.readAllLines(target.toPath()))));
                        }
                        catch (IOException ex) {
                            throw new ProcessException("Failed to read contents of file " + target.getName() + ": " + ex.getMessage(), ex);
                        }
                        catch (IllegalArgumentException ex) {
                            throw new IllegalArgumentException("File " + target.getName() + ": " + ex.getMessage());
                        }
                    } else {
                        this.parentHandler.writeFileContents(target);
                    }
                    this.parentHandler.write("</media-fragment>");
                }
                catch (SAXException ex) {
                    throw new ProcessException("Failed to write contents of file " + target.getName() + ": " + ex.getMessage(), ex);
                }
                return true;
            }
            String fragment = image || link ? "default" : atts.getValue("frag");
            List<String> fragments = this.parentFiles.get(target);
            if (fragments != null && fragments.contains(fragment)) {
                throw new InfiniteLoopException();
            }
            this.parentHandler.getLogger().debug("Transcluding XRef to {}", (Object)href);
            NumberedTOCGenerator numberingAndTOC = this.parentHandler.getNumberedTOCGenerator();
            String levelAtt = atts.getValue("level");
            int level = levelAtt != null && !levelAtt.isEmpty() && ("transclude".equals(type) || numberingAndTOC == null) ? Integer.parseInt(levelAtt) : 0;
            PSMLProcessHandler handler = this.parentHandler.cloneForTransclusion(target, uriid, fragment, level, image, inEmbedHierarchy && "embed".equals(type), "transclude".equals(type), "alternate".equals(type) || this.parentHandler.inAlternateXRef());
            handler.getTranscluder().parentFiles.putAll(this.parentFiles);
            XMLUtils.parse(target, (ContentHandler)handler);
            if (numberingAndTOC != null) {
                XMLStringWriter out = new XMLStringWriter(XML.NamespaceAware.No);
                TransclusionHandler thandler = new TransclusionHandler((XMLWriter)out, "default", true, handler);
                XMLUtils.parse(target, (ContentHandler)thandler);
                DocumentTreeHandler tochandler = new DocumentTreeHandler();
                XMLUtils.parse(new InputSource(new StringReader(out.toString())), (ContentHandler)tochandler, null, null);
                DocumentTree tree = (DocumentTree)tochandler.get();
                if (tree != null) {
                    tree = tree.normalize(this.parentHandler.getPublicationConfig().getTocTitleCollapse());
                    numberingAndTOC.addTree(tree);
                }
            }
            return true;
        }
        return false;
    }

    public @Nullable File findXRefTarget(@Nullable String href, @Nullable String uriid, boolean link) {
        File target;
        if (href == null) {
            return null;
        }
        String path = href.replaceFirst("\\?(.*?)?$", "");
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        String dadPath = this.parentHandler.cleanUpParentFolder();
        if (link) {
            try {
                URL u = new URL(href);
                String scheme = u.getProtocol();
                int port = u.getPort();
                if (port == -1) {
                    port = "https".equals(scheme) ? 443 : ("http".equals(scheme) ? 80 : -1);
                }
                target = new File(this.parentHandler.getPSMLRoot(), "META-INF/_urls/" + scheme + "/" + u.getHost() + "/" + port + "/" + uriid + ".psml");
            }
            catch (MalformedURLException ex) {
                this.parentHandler.getLogger().error("Invalid link URL: " + ex.getMessage(), (Throwable)ex);
                target = null;
            }
        } else {
            target = path.endsWith(".psml") ? new File(this.parentHandler.getPSMLRoot(), dadPath + "/" + path) : (path.endsWith(".mml") || path.endsWith(".mathml") || path.endsWith(".tex") ? new File(this.parentHandler.getBinaryRepository(), dadPath + "/" + path) : new File(this.parentHandler.getPSMLRoot(), "META-INF/" + dadPath + "/" + path + ".psml"));
            try {
                target = target.getCanonicalFile();
            }
            catch (IOException ex) {
                this.parentHandler.getLogger().error(ex.getMessage(), (Throwable)ex);
            }
        }
        return target;
    }

    public @Nullable String findXRefRelativePath(@Nullable String href) {
        if (href == null) {
            return null;
        }
        String path = href.replaceFirst("\\?(.*?)?$", "");
        path = URLDecoder.decode(path, StandardCharsets.UTF_8);
        String dadPath = this.parentHandler.getParentFolderRelativePath();
        if (path.endsWith(".psml")) {
            File target = new File(this.parentHandler.getPSMLRoot(), dadPath + "/" + path);
            if (!path.startsWith("/")) {
                return Files.computeRelativePath(target, this.parentHandler.getPSMLRoot());
            }
        } else {
            File target = new File(this.parentHandler.getBinaryRepository(), dadPath + "/" + path);
            if (!path.startsWith("/")) {
                return Files.computeRelativePath(target, this.parentHandler.getBinaryRepository());
            }
        }
        return null;
    }

    public static class TooDeepException
    extends ProcessException {
        private static final long serialVersionUID = 1L;

        TooDeepException() {
            super("Maximum processing depth (50) exceeded.");
        }
    }

    public static class InfiniteLoopException
    extends ProcessException {
        private static final long serialVersionUID = 1L;

        InfiniteLoopException() {
            super("Infinite loop detected.");
        }
    }

    public static class XRefNotFoundException
    extends ProcessException {
        private static final long serialVersionUID = 1L;

        XRefNotFoundException() {
            super("XRef not found.");
        }
    }
}

