/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ImageCache;
import org.pageseeder.psml.process.ManifestCreator;
import org.pageseeder.psml.process.NumberedTOCGenerator;
import org.pageseeder.psml.process.PSMLProcessHandler;
import org.pageseeder.psml.process.PSMLProcessHandler2;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.config.ErrorHandling;
import org.pageseeder.psml.process.config.Images;
import org.pageseeder.psml.process.config.ManifestDocument;
import org.pageseeder.psml.process.config.Strip;
import org.pageseeder.psml.process.config.WarningHandling;
import org.pageseeder.psml.process.config.XRefsTransclude;
import org.pageseeder.psml.process.config.XSLTTransformation;
import org.pageseeder.psml.process.math.AsciiMathConverter;
import org.pageseeder.psml.process.util.Files;
import org.pageseeder.psml.process.util.IncludesExcludesMatcher;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.psml.process.util.XSLTTransformer;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.XRefLoopException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class Process {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final int BUFFER_SIZE = 12288;
    private @Nullable Logger logger = null;
    private @Nullable File src = null;
    private @Nullable File dest = null;
    private boolean generateToc = false;
    private boolean failOnError = true;
    private boolean processed = true;
    private boolean preserveSrc = false;
    private boolean embedLinkMetadata = false;
    private boolean convertMarkdown = false;
    private boolean convertAsciiMath = false;
    private boolean convertTex = false;
    private boolean placeholders = false;
    private boolean processXML = false;
    private @Nullable ManifestCreator manifestCreator = null;
    private @Nullable XSLTTransformer preTransform = null;
    private @Nullable XRefsTransclude xrefs = null;
    private @Nullable Strip strip = null;
    private @Nullable Images imageHandling = null;
    private @Nullable IncludesExcludesMatcher imageMatcher = null;
    private @Nullable PublicationConfig publicationConfig = null;
    private @Nullable String publicationRoot = null;
    private @Nullable XSLTTransformer postTransform = null;
    private @Nullable ErrorHandling error = null;
    private @Nullable WarningHandling warning = null;

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
        this.processXML = true;
    }

    public void setPreserveSrc(boolean preserve) {
        this.preserveSrc = preserve;
    }

    public void setConvertMarkdown(boolean convert) {
        this.convertMarkdown = convert;
        this.processXML = true;
    }

    public void setEmbedLinkMetadata(boolean embed) {
        this.embedLinkMetadata = embed;
        this.processXML = true;
    }

    public void setConvertAsciiMath(boolean convert) {
        this.convertAsciiMath = convert;
        this.processXML = true;
    }

    public void setConvertTex(boolean convert) {
        this.convertTex = convert;
        this.processXML = true;
    }

    public void setPlaceholders(boolean resolve) {
        this.placeholders = resolve;
        this.processXML = true;
    }

    public void setDest(File destination) {
        this.dest = destination;
    }

    public void setSrc(File source) {
        this.src = source;
    }

    public void setLogger(Logger log) {
        this.logger = log;
    }

    public void setManifestDoc(@Nullable ManifestDocument manifestDoc) {
        if (manifestDoc != null) {
            this.manifestCreator = new ManifestCreator(manifestDoc);
        }
    }

    public void setPreTransform(@Nullable XSLTTransformation transform) {
        if (transform != null) {
            this.preTransform = new XSLTTransformer(transform);
        }
    }

    public void setPostTransform(@Nullable XSLTTransformation transform) {
        if (transform != null) {
            this.postTransform = new XSLTTransformer(transform);
        }
    }

    public void setPublicationConfig(@Nullable PublicationConfig cfg, @Nullable String root, boolean toc) {
        if (cfg == null || root == null) {
            throw new IllegalArgumentException("Publication config and root cannot be null");
        }
        this.publicationConfig = cfg;
        this.publicationRoot = root;
        this.generateToc = toc;
        this.processXML = true;
    }

    public void setImageMatcher(IncludesExcludesMatcher matcher) {
        this.imageMatcher = matcher;
    }

    public void setError(@Nullable ErrorHandling err) {
        if (err == null) {
            return;
        }
        this.error = err;
        if (this.error.getImageNotFound() || this.error.getXrefNotFound() || this.error.getXrefAmbiguous()) {
            this.processXML = true;
        }
    }

    public void setWarning(@Nullable WarningHandling warn) {
        if (warn == null) {
            return;
        }
        this.warning = warn;
    }

    public void setXrefs(@Nullable XRefsTransclude xr) {
        if (xr == null) {
            return;
        }
        this.xrefs = xr;
        this.processXML = true;
    }

    public void setStrip(@Nullable Strip stripDetails) {
        if (stripDetails == null) {
            return;
        }
        this.strip = stripDetails;
        this.processXML = true;
    }

    public void setImages(@Nullable Images img) {
        if (img == null) {
            return;
        }
        this.imageHandling = img;
        this.processXML = true;
    }

    /*
     * WARNING - void declaration
     */
    public void process() throws ProcessException {
        if (this.src == null) {
            throw new ProcessException("Src must be specified");
        }
        if (!this.src.exists() || !this.src.isDirectory()) {
            throw new ProcessException("Invalid src location");
        }
        if (this.dest == null) {
            throw new ProcessException("Dest must be specified");
        }
        if (!this.dest.exists() || !this.dest.isDirectory()) {
            throw new ProcessException("Invalid destination folder");
        }
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(Process.class);
        }
        this.logger.debug("Collecting PSML files from {}", (Object)this.src.getAbsolutePath());
        HashMap<String, File> psml = new HashMap<String, File>();
        HashMap<String, File> rest = new HashMap<String, File>();
        this.collectAll(this.src, psml, null, rest);
        String processID = "P" + System.currentTimeMillis();
        this.logger.info("Found {} PSML file(s) and {} non PSML file(s)", (Object)psml.size(), (Object)rest.size());
        File manifestFile = null;
        if (this.manifestCreator != null) {
            this.logger.info("Creating manifest document");
            this.manifestCreator.setLog(this.logger);
            manifestFile = this.manifestCreator.createManifest(psml, this.src);
            if (manifestFile != null) {
                psml.put(Files.computeRelativePath(manifestFile, this.src), manifestFile);
            }
        }
        String tempFolder = System.getProperty("java.io.tmpdir");
        ArrayList<File> tempFoldersToDelete = new ArrayList<File>();
        File[] ffiles = this.dest.listFiles();
        List<Object> originalFilesInDestination = ffiles == null ? new ArrayList() : Arrays.asList(ffiles);
        try {
            boolean parseMetadata;
            File currentSource = this.src;
            if (this.preTransform != null) {
                File output;
                boolean useOutputToTempDir;
                this.logger.info("Running Pre Transform with {}", (Object)this.preTransform.getXSLT());
                this.preTransform.setLog(this.logger);
                this.preTransform.setPreserveSrc(this.preserveSrc);
                this.preTransform.setFailOnError(this.failOnError);
                boolean bl = useOutputToTempDir = this.processXML || this.postTransform != null;
                if (useOutputToTempDir) {
                    output = new File(tempFolder, "pretransform-" + processID);
                    this.logger.debug("Creating temp output folder {}", (Object)output.getAbsolutePath());
                    output.mkdirs();
                    tempFoldersToDelete.add(output);
                } else {
                    output = this.dest;
                }
                this.preTransform.transform(psml, output);
                if (useOutputToTempDir) {
                    psml.clear();
                    this.collectPSML(output, psml);
                    currentSource = output;
                }
            }
            ImageCache imageCache = new ImageCache(new File(this.src, "META-INF"));
            boolean bl = parseMetadata = this.strip != null;
            if (this.processXML) {
                void var13_22;
                boolean useOutputToTempDir;
                this.logger.info("Processing content PSML (XRefs, images, strip, numbering)");
                boolean bl2 = useOutputToTempDir = this.postTransform != null;
                if (useOutputToTempDir) {
                    File file = new File(tempFolder, "process-" + processID);
                    this.logger.debug("Creating temp output folder {}", (Object)file.getAbsolutePath());
                    file.mkdirs();
                    tempFoldersToDelete.add(file);
                } else {
                    File file = this.dest;
                }
                this.process(psml, currentSource, (File)var13_22, this.src, imageCache);
                if (useOutputToTempDir) {
                    psml.clear();
                    this.collectPSML((File)var13_22, psml);
                }
            }
            if (this.postTransform != null) {
                this.logger.info("Running Post Transform with {}", (Object)this.postTransform.getXSLT());
                this.postTransform.setLog(this.logger);
                this.postTransform.setPreserveSrc(this.preserveSrc);
                this.postTransform.setFailOnError(this.failOnError);
                this.postTransform.transform(psml, this.dest);
            } else if (this.preTransform == null && !this.processXML) {
                this.logger.info("Moving {} PSML content file(s)", (Object)psml.size());
                for (Map.Entry entry : psml.entrySet()) {
                    this.moveFile((File)entry.getValue(), new File(this.dest, (String)entry.getKey()));
                }
            }
            boolean moveImages = this.imageHandling != null && this.imageHandling.getLocation() != null;
            this.logger.info("Moving {} non PSML file(s)", (Object)rest.size());
            if (moveImages) {
                this.logger.info("Moving images to {}", (Object)this.imageHandling.getLocation());
            }
            for (Map.Entry entry : rest.entrySet()) {
                File target;
                String relPath = (String)entry.getKey();
                if ("META-INF/manifest.xml".equals(relPath) && this.strip != null && this.strip.stripManifest()) continue;
                File other = (File)entry.getValue();
                if (moveImages && imageCache.isCached(relPath)) {
                    String newPath = this.imageHandling.getSrc() == Images.ImageSrc.LOCATION ? relPath : imageCache.getImageNewPath(relPath);
                    target = new File(this.imageHandling.getLocation(), newPath);
                } else {
                    target = new File(this.dest, relPath);
                }
                this.moveFile(other, target);
            }
            if (!tempFoldersToDelete.isEmpty()) {
                this.logger.debug("Removing {} temp folder(s)", (Object)tempFoldersToDelete.size());
                for (File file : tempFoldersToDelete) {
                    if (this.deleteDirectory(file, true)) continue;
                    this.logger.warn("Failed to remove temp folder {}", (Object)file.getAbsolutePath());
                }
            }
            if (!this.preserveSrc) {
                this.logger.debug("Removing source document(s)");
                if (!this.deleteDirectory(this.src, false)) {
                    throw new ProcessException("Failed to delete source files");
                }
            } else if (manifestFile != null && !manifestFile.delete()) {
                throw new ProcessException("Failed to delete manifest file " + manifestFile.getAbsolutePath());
            }
        }
        catch (ProcessException ex) {
            if (manifestFile != null && manifestFile.exists() && !manifestFile.delete()) {
                this.logger.warn("Failed to delete manifest file {}", (Object)manifestFile.getAbsolutePath());
            }
            if (ffiles != null) {
                for (File file : ffiles) {
                    if (originalFilesInDestination.contains(file)) continue;
                    if (file.isFile()) {
                        if (file.delete()) continue;
                        this.logger.warn("Failed to delete created file {}", (Object)file.getName());
                        continue;
                    }
                    if (this.deleteDirectory(file, true)) continue;
                    this.logger.warn("Failed to delete created folder {}", (Object)file.getName());
                }
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Map<String, File> psmlFiles, File source, File destination, File binaries, ImageCache cache) throws ProcessException {
        if (!this.processXML) {
            return;
        }
        AsciiMathConverter.reset();
        IncludesExcludesMatcher xrefsMatcher = this.xrefs == null ? null : this.xrefs.buildMatcher();
        for (Map.Entry<String, File> fileEntry : psmlFiles.entrySet()) {
            FileOutputStream fos;
            File tempOutput;
            String relPath = fileEntry.getKey();
            this.logger.debug("Processing file {}", (Object)relPath);
            try {
                tempOutput = File.createTempFile("temp", ".psml");
                fos = new FileOutputStream(tempOutput);
            }
            catch (IOException e) {
                this.logger.error("Failed to create temp output file: {}", (Object)e.getMessage(), (Object)e);
                throw new ProcessException("Failed to create temp output file: " + e.getMessage(), e);
            }
            File psml = fileEntry.getValue();
            PSMLProcessHandler handler1 = new PSMLProcessHandler(new OutputStreamWriter((OutputStream)fos, UTF8), null, psml, source, binaries);
            handler1.setLogger(this.logger);
            handler1.setFailOnError(this.failOnError);
            handler1.setProcessed(this.processed);
            handler1.setConvertMarkdown(this.convertMarkdown);
            handler1.setConvertAsciiMath(this.convertAsciiMath);
            handler1.setConvertTex(this.convertTex);
            handler1.setPlaceholders(this.placeholders);
            List<String> xrefsTypes = null;
            boolean excludeXRefFrag = false;
            boolean onlyXRefFrag = false;
            if (this.xrefs != null && this.xrefs.getTypes() != null && (xrefsMatcher == null || !xrefsMatcher.hasPatterns() || xrefsMatcher.matches(relPath))) {
                xrefsTypes = Arrays.asList(this.xrefs.getTypes().toLowerCase().split(","));
                excludeXRefFrag = this.xrefs.excludeXRefsInXRefFragment();
                onlyXRefFrag = this.xrefs.onlyXRefsInXRefFragment();
                if (!this.xrefs.getLevels()) {
                    this.logger.error("XRef levels option is no longer supported, use publication config instead.");
                }
            }
            handler1.setXRefsHandling(xrefsTypes, excludeXRefFrag, onlyXRefFrag, this.error != null && this.error.getXrefNotFound(), this.warning == null || this.warning.getXrefNotFound());
            handler1.setEmbedLinkMetadata(this.embedLinkMetadata);
            boolean embedMetadata = false;
            ImageCache thecache = null;
            Images.ImageSrc imageSrc = Images.ImageSrc.LOCATION;
            String siteprefix = null;
            if (this.imageHandling != null && (this.imageMatcher == null || !this.imageMatcher.hasPatterns() || this.imageMatcher.matches(relPath))) {
                thecache = cache;
                imageSrc = this.imageHandling.getSrc();
                siteprefix = this.imageHandling.getSitePrefix();
                embedMetadata = this.imageHandling.isMetadataEmbedded();
            }
            handler1.setImageHandling(thecache, imageSrc, this.error != null && this.error.getImageNotFound(), this.warning == null || this.warning.getImageNotFound(), siteprefix, embedMetadata);
            try {
                if (this.publicationConfig != null && this.publicationRoot.equals(relPath)) {
                    handler1.setPublicationConfig(this.publicationConfig, psml, this.generateToc);
                }
                handler1.setStrip(this.strip);
                XMLUtils.parse(psml, (ContentHandler)handler1);
            }
            catch (ProcessException e) {
                if (this.failOnError) {
                    throw e;
                }
                this.logger.error(e.getMessage());
            }
            catch (Throwable e) {
                throw new ProcessException("Failed to process " + relPath + ": " + e.getMessage(), e);
            }
            finally {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    throw new ProcessException("Failed to close output stream: " + ex.getMessage(), ex);
                }
            }
            this.logger.debug("Second pass file {}", (Object)relPath);
            try {
                File output = new File(destination, relPath);
                output.getParentFile().mkdirs();
                if (!output.exists() && !output.createNewFile()) {
                    throw new ProcessException("Failed to create output file " + output.getAbsolutePath());
                }
                fos = new FileOutputStream(output);
            }
            catch (IOException e) {
                this.logger.error("Failed to create output file: " + e.getMessage(), (Throwable)e);
                throw new ProcessException("Failed to create output file: " + e.getMessage(), e);
            }
            PSMLProcessHandler2 handler2 = new PSMLProcessHandler2(new OutputStreamWriter((OutputStream)fos, UTF8), relPath);
            handler2.setLogger(this.logger);
            handler2.setFailOnError(this.failOnError);
            handler2.setErrorOnAmbiguous(this.error != null && this.error.getXrefAmbiguous());
            handler2.setWarnOnAmbiguous(this.warning == null || this.warning.getXrefAmbiguous());
            handler2.setHierarchyUriFragIDs(handler1.getHierarchyUriFragIDs());
            handler2.setRelativiseImagePaths(imageSrc == Images.ImageSrc.LOCATION);
            handler2.setProcessed(this.processed);
            handler2.setProcessXRefs(xrefsTypes != null);
            try {
                NumberedTOCGenerator numberingAndTOC = handler1.getNumberedTOCGenerator();
                if (numberingAndTOC != null) {
                    numberingAndTOC.updatePublication();
                    numberingAndTOC.setFragmentNumbering(new FragmentNumbering(numberingAndTOC.publicationTree(), this.publicationConfig));
                    handler2.setPublicationConfig(this.publicationConfig, numberingAndTOC, this.generateToc);
                }
                XMLUtils.parse(tempOutput, (ContentHandler)handler2);
            }
            catch (XRefLoopException e) {
                throw new ProcessException(e.getMessage(), e);
            }
            catch (ProcessException e) {
                if (this.failOnError) {
                    throw e;
                }
                this.logger.error(e.getMessage());
            }
            finally {
                tempOutput.delete();
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    throw new ProcessException("Failed to close output stream: " + ex.getMessage(), ex);
                }
            }
        }
        this.logger.debug("Complete");
    }

    private void moveFile(File from, File to) throws ProcessException {
        block16: {
            to.getParentFile().mkdirs();
            if (this.preserveSrc) {
                try (FileInputStream fis = new FileInputStream(from);
                     FileOutputStream fos = new FileOutputStream(to);){
                    int read;
                    byte[] buffer = new byte[12288];
                    while ((read = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, read);
                    }
                    break block16;
                }
                catch (IOException ex) {
                    throw new ProcessException("Failed to copy file " + from.getAbsolutePath() + " to " + to.getAbsolutePath(), ex);
                }
            }
            try {
                java.nio.file.Files.move(from.toPath(), to.toPath(), new CopyOption[0]);
            }
            catch (IOException ex) {
                throw new ProcessException("Failed to move file " + from.getAbsolutePath() + " to " + to.getAbsolutePath(), ex);
            }
        }
    }

    private void collectPSML(File file, Map<String, File> psml) {
        this.collectFiles(file, file, psml, null, null, true);
    }

    private void collectAll(File file, Map<String, File> psml, Map<String, File> metadata, Map<String, File> others) {
        this.collectFiles(file, file, psml, metadata, others, true);
    }

    private void collectFiles(File file, File root, Map<String, File> psml, @Nullable Map<String, File> metadata, @Nullable Map<String, File> others, boolean isRoot) {
        if (file.isDirectory()) {
            File[] all = file.listFiles();
            if (all != null) {
                for (File f : all) {
                    if (isRoot && "META-INF".equals(f.getName()) && metadata != null) {
                        this.collectFiles(f, root, metadata, metadata, others, false);
                        continue;
                    }
                    this.collectFiles(f, root, psml, metadata, others, false);
                }
            }
        } else if (file.isFile() && file.getName().toLowerCase().endsWith(".psml")) {
            psml.put(Files.computeRelativePath(file, root), file);
        } else if (others != null) {
            others.put(Files.computeRelativePath(file, root), file);
        }
    }

    private boolean deleteDirectory(File dir, boolean deleteSelf) {
        for (File child : dir.listFiles()) {
            if (!(child.isFile() ? !child.delete() : !this.deleteDirectory(child, true))) continue;
            return false;
        }
        if (!deleteSelf) {
            return true;
        }
        return dir.delete();
    }
}

