/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.stream.Collectors;
import org.pageseeder.psml.html.HTMLElement;
import org.pageseeder.psml.md.BlockParser;
import org.pageseeder.psml.md.Configuration;
import org.pageseeder.psml.md.HTMLBlockParser;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.spi.Parser;
import org.pageseeder.psml.util.DiagnosticCollector;
import org.pageseeder.psml.util.NilDiagnosticCollector;

public class MarkdownParser
extends Parser {
    private Configuration config = new Configuration();

    @Override
    public String getMediatype() {
        return "text/markdown";
    }

    public void setConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public PSMLElement parse(Reader reader) throws IOException {
        return this.parse(reader, new NilDiagnosticCollector());
    }

    public PSMLElement parse(Reader reader, DiagnosticCollector collector) throws IOException {
        PSMLElement wrapper;
        List<String> lines = MarkdownParser.toLines(reader);
        BlockParser parser = new BlockParser(this.config.toMarkdownInputOptions());
        List<PSMLElement> elements = parser.parse(lines, collector);
        if (this.config.isFragment()) {
            wrapper = new PSMLElement(PSMLElement.Name.FRAGMENT);
        } else {
            wrapper = new PSMLElement(PSMLElement.Name.DOCUMENT);
            wrapper.setAttribute("level", "portable");
        }
        wrapper.addNodes(elements);
        return wrapper;
    }

    public HTMLElement parseToHTML(Reader reader) throws IOException {
        List<String> lines = MarkdownParser.toLines(reader);
        HTMLBlockParser parser = new HTMLBlockParser(this.config.toMarkdownInputOptions());
        List<HTMLElement> elements = parser.parse(lines);
        HTMLElement wrapper = this.config.isFragment() ? new HTMLElement(HTMLElement.Name.SECTION) : new HTMLElement(HTMLElement.Name.SECTION);
        wrapper.addNodes(elements);
        return wrapper;
    }

    private static List<String> toLines(Reader reader) throws IOException {
        try (BufferedReader br = new BufferedReader(reader);){
            List<String> list = br.lines().collect(Collectors.toList());
            return list;
        }
    }
}

