/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.util.Objects;

public final class MarkdownOutputOptions {
    private final boolean metadata;
    private final boolean captions;
    private final ImageFormat image;
    private final XrefFormat xref;
    private final BlockFormat block;
    private final SuperSubFormat superSub;
    private final UnderlineFormat underline;
    private final PropertiesFormat properties;
    private final TableFormat table;

    private MarkdownOutputOptions(boolean metadata, boolean captions, ImageFormat image, XrefFormat xref, BlockFormat block, SuperSubFormat superSub, UnderlineFormat underline, PropertiesFormat properties, TableFormat table) {
        this.metadata = metadata;
        this.captions = captions;
        this.image = Objects.requireNonNull(image);
        this.xref = Objects.requireNonNull(xref);
        this.block = Objects.requireNonNull(block);
        this.superSub = Objects.requireNonNull(superSub);
        this.underline = Objects.requireNonNull(underline);
        this.properties = Objects.requireNonNull(properties);
        this.table = Objects.requireNonNull(table);
    }

    public static MarkdownOutputOptions defaultOptions() {
        return new MarkdownOutputOptions(true, false, ImageFormat.LOCAL, XrefFormat.BOLD_TEXT, BlockFormat.QUOTED, SuperSubFormat.IGNORE, UnderlineFormat.IGNORE, PropertiesFormat.TABLE, TableFormat.PRETTY);
    }

    public boolean metadata() {
        return this.metadata;
    }

    public boolean captions() {
        return this.captions;
    }

    public ImageFormat image() {
        return this.image;
    }

    public XrefFormat xref() {
        return this.xref;
    }

    public BlockFormat block() {
        return this.block;
    }

    public SuperSubFormat superSub() {
        return this.superSub;
    }

    public UnderlineFormat underline() {
        return this.underline;
    }

    public PropertiesFormat properties() {
        return this.properties;
    }

    public TableFormat table() {
        return this.table;
    }

    public MarkdownOutputOptions metadata(boolean include) {
        return new MarkdownOutputOptions(include, this.captions, this.image, this.xref, this.block, this.superSub, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions captions(boolean include) {
        return new MarkdownOutputOptions(this.metadata, include, this.image, this.xref, this.block, this.superSub, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions image(ImageFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, format, this.xref, this.block, this.superSub, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions xref(XrefFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, format, this.block, this.superSub, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions block(BlockFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, format, this.superSub, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions superSub(SuperSubFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, this.block, format, this.underline, this.properties, this.table);
    }

    public MarkdownOutputOptions underline(UnderlineFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, this.block, this.superSub, format, this.properties, this.table);
    }

    public MarkdownOutputOptions properties(PropertiesFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, this.block, this.superSub, this.underline, format, this.table);
    }

    public MarkdownOutputOptions table(TableFormat format) {
        return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, this.block, this.superSub, this.underline, this.properties, format);
    }

    public Builder builder() {
        return Builder.from(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarkdownOutputOptions that = (MarkdownOutputOptions)o;
        return this.metadata == that.metadata && this.captions == that.captions && this.image == that.image && this.xref == that.xref && this.block == that.block && this.superSub == that.superSub && this.underline == that.underline && this.properties == that.properties && this.table == that.table;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.metadata, this.captions, this.image, this.xref, this.block, this.superSub, this.underline, this.properties, this.table});
    }

    public String toString() {
        return "MarkdownOutputOptions{metadata=" + this.metadata + ", captions=" + this.captions + ", image=" + String.valueOf((Object)this.image) + ", xref=" + String.valueOf((Object)this.xref) + ", block=" + String.valueOf((Object)this.block) + ", superSub=" + String.valueOf((Object)this.superSub) + ", underline=" + String.valueOf((Object)this.underline) + ", properties=" + String.valueOf((Object)this.properties) + ", table=" + String.valueOf((Object)this.table) + "}";
    }

    public static class Builder {
        private boolean metadata = true;
        private boolean captions = false;
        private ImageFormat image = ImageFormat.LOCAL;
        private XrefFormat xref = XrefFormat.BOLD_TEXT;
        private BlockFormat block = BlockFormat.QUOTED;
        private SuperSubFormat superSub = SuperSubFormat.IGNORE;
        private UnderlineFormat underline = UnderlineFormat.IGNORE;
        private PropertiesFormat properties = PropertiesFormat.TABLE;
        private TableFormat table = TableFormat.PRETTY;

        public static Builder from(MarkdownOutputOptions options) {
            Builder builder = new Builder();
            builder.metadata = options.metadata();
            builder.captions = options.captions();
            builder.image = options.image();
            builder.xref = options.xref();
            builder.block = options.block();
            builder.superSub = options.superSub();
            builder.underline = options.underline();
            builder.properties = options.properties();
            builder.table = options.table();
            return builder;
        }

        public Builder metadata(boolean include) {
            this.metadata = include;
            return this;
        }

        public Builder captions(boolean include) {
            this.captions = include;
            return this;
        }

        public Builder image(ImageFormat format) {
            this.image = Objects.requireNonNull(format);
            return this;
        }

        public Builder xref(XrefFormat format) {
            this.xref = Objects.requireNonNull(format);
            return this;
        }

        public Builder block(BlockFormat format) {
            this.block = Objects.requireNonNull(format);
            return this;
        }

        public Builder superSub(SuperSubFormat format) {
            this.superSub = Objects.requireNonNull(format);
            return this;
        }

        public Builder underline(UnderlineFormat format) {
            this.underline = Objects.requireNonNull(format);
            return this;
        }

        public Builder properties(PropertiesFormat format) {
            this.properties = Objects.requireNonNull(format);
            return this;
        }

        public Builder table(TableFormat format) {
            this.table = Objects.requireNonNull(format);
            return this;
        }

        public MarkdownOutputOptions build() {
            return new MarkdownOutputOptions(this.metadata, this.captions, this.image, this.xref, this.block, this.superSub, this.underline, this.properties, this.table);
        }
    }

    public static enum TableFormat {
        COMPACT,
        PRETTY,
        NORMALIZED,
        HTML;

    }

    public static enum PropertiesFormat {
        VALUE_PAIRS,
        TABLE;

    }

    public static enum UnderlineFormat {
        HTML,
        IGNORE;

    }

    public static enum SuperSubFormat {
        HTML,
        CARET_TILDE,
        UNICODE,
        IGNORE;

    }

    public static enum BlockFormat {
        QUOTED,
        FENCED,
        LABELED;

    }

    public static enum XrefFormat {
        EXTERNAL_LINK,
        LOCAL_LINK,
        BOLD_TEXT,
        TEXT;

    }

    public static enum ImageFormat {
        LOCAL,
        EXTERNAL,
        DATA_URI,
        IMG_TAG,
        NONE;

    }
}

