/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pageseeder.psml.model.PSMLElement;
import org.pageseeder.psml.model.PSMLNode;
import org.pageseeder.psml.model.PSMLText;

public class InlineParser {
    private static final String DOUBLE_EMPHASIS = "(\\*\\*(.*?)\\*\\*)";
    private static final String EMPHASIS = "(\\*(.*?)\\*)";
    private static final String DOUBLE_UNDERSCORE = "(__(.*?)__)";
    private static final String UNDERSCORE = "(\\b_(.*?)_\\b)";
    private static final String CODE_ESCAPE = "(``\\s?(.*?)\\s?``)";
    private static final String CODE = "(`(.*?)`)";
    private static final String IMAGE = "(\\!\\[(.*?)\\]\\((.*?)\\))";
    private static final String REF = "(\\[(.*?)\\]\\((.*?)\\))";
    private static final String LINK = "(<((https?://|mailto:)(.*?))>)";
    private static final String LINK_AUTO = "(https?://\\S+[\\w/+=@\\-])";
    private static final Pattern TOKENS = Pattern.compile("(\\*\\*(.*?)\\*\\*)|(__(.*?)__)|(\\*(.*?)\\*)|(\\b_(.*?)_\\b)|(``\\s?(.*?)\\s?``)|(`(.*?)`)|(\\!\\[(.*?)\\]\\((.*?)\\))|(\\[(.*?)\\]\\((.*?)\\))|(<((https?://|mailto:)(.*?))>)|(https?://\\S+[\\w/+=@\\-])");
    private static final Pattern ESCAPED = Pattern.compile("\\\\(-|`|\\*|_|\\[|\\]|\\\\|!|<|>|\\.)");

    public List<PSMLNode> parse(String content) {
        return this.parse(content, false);
    }

    private List<PSMLNode> parse(String content, boolean inLink) {
        String text;
        ArrayList<PSMLNode> nodes = new ArrayList<PSMLNode>();
        Matcher m = TOKENS.matcher(content);
        int previousEnd = 0;
        while (m.find()) {
            String url;
            String text2;
            PSMLElement monospace;
            String code;
            PSMLElement element;
            if (m.start() > previousEnd) {
                text = content.substring(previousEnd, m.start());
                if (text.endsWith("\\")) {
                    nodes.add(new PSMLText(InlineParser.unescape(text + content.substring(m.start(), m.end()))));
                    previousEnd = m.end();
                    continue;
                }
                nodes.add(new PSMLText(InlineParser.unescape(text)));
            }
            previousEnd = m.end();
            if (m.group(1) != null) {
                element = new PSMLElement(PSMLElement.Name.BOLD);
                element.addNodes(this.parse(m.group(2)));
                nodes.add(element);
            } else if (m.group(3) != null) {
                element = new PSMLElement(PSMLElement.Name.BOLD);
                element.addNodes(this.parse(m.group(4)));
                nodes.add(element);
            }
            if (m.group(5) != null) {
                element = new PSMLElement(PSMLElement.Name.ITALIC);
                element.addNodes(this.parse(m.group(6)));
                nodes.add(element);
                continue;
            }
            if (m.group(7) != null) {
                element = new PSMLElement(PSMLElement.Name.ITALIC);
                element.addNodes(this.parse(m.group(8)));
                nodes.add(element);
                continue;
            }
            if (m.group(9) != null) {
                code = m.group(10);
                monospace = new PSMLElement(PSMLElement.Name.MONOSPACE);
                if (!code.isEmpty()) {
                    monospace.addNode(new PSMLText(code));
                }
                nodes.add(monospace);
                continue;
            }
            if (m.group(11) != null) {
                code = m.group(12);
                monospace = new PSMLElement(PSMLElement.Name.MONOSPACE);
                if (!code.isEmpty()) {
                    monospace.addNode(new PSMLText(code));
                }
                nodes.add(monospace);
                continue;
            }
            if (m.group(13) != null && !inLink) {
                String alt = m.group(14);
                String src = m.group(15);
                if (src.startsWith("http")) {
                    PSMLElement link = new PSMLElement(PSMLElement.Name.LINK);
                    link.setAttribute("href", InlineParser.unescape(src));
                    link.addNodes(this.parse(alt, true));
                    nodes.add(link);
                    continue;
                }
                PSMLElement image = new PSMLElement(PSMLElement.Name.IMAGE);
                image.setAttribute("alt", InlineParser.unescape(alt));
                image.setAttribute("src", InlineParser.unescape(src));
                nodes.add(image);
                continue;
            }
            if (m.group(16) != null && !inLink) {
                String ref = m.group(18);
                text2 = m.group(17);
                if (ref.startsWith("http")) {
                    PSMLElement link = new PSMLElement(PSMLElement.Name.LINK);
                    link.setAttribute("href", InlineParser.unescape(ref));
                    link.addNodes(this.parse(text2, true));
                    nodes.add(link);
                    continue;
                }
                int hash = ref.indexOf(35);
                String url2 = hash < 0 ? ref : ref.substring(0, hash);
                String fragment = hash < 0 ? "default" : ref.substring(hash + 1);
                PSMLElement xref = new PSMLElement(PSMLElement.Name.XREF);
                xref.setAttribute("display", "manual");
                xref.setAttribute("reverselink", "true");
                xref.setAttribute("title", InlineParser.unescape(text2));
                xref.setAttribute("href", InlineParser.unescape(url2));
                xref.setAttribute("frag", InlineParser.unescape(fragment));
                xref.addNode(new PSMLText(InlineParser.unescape(text2)));
                nodes.add(xref);
                continue;
            }
            if (m.group(19) != null && !inLink) {
                url = m.group(20);
                text2 = m.group(22);
                PSMLElement link = new PSMLElement(PSMLElement.Name.LINK);
                link.setAttribute("href", InlineParser.unescape(url));
                link.addNode(new PSMLText(InlineParser.unescape(text2)));
                nodes.add(link);
                continue;
            }
            if (m.group(23) != null && !inLink) {
                url = m.group(23);
                PSMLElement link = new PSMLElement(PSMLElement.Name.LINK);
                link.setAttribute("href", InlineParser.unescape(url));
                link.addNode(new PSMLText(InlineParser.unescape(url)));
                nodes.add(link);
                continue;
            }
            if (!inLink) continue;
            nodes.add(new PSMLText(InlineParser.unescape(content)));
        }
        if (previousEnd < content.length()) {
            text = content.substring(previousEnd);
            nodes.add(new PSMLText(InlineParser.unescape(text)));
        }
        return nodes;
    }

    public static String unescape(String text) {
        if (text.indexOf(92) == -1) {
            return text;
        }
        Matcher m = ESCAPED.matcher(text);
        StringBuilder out = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(out, "$1");
        }
        m.appendTail(out);
        return out.toString();
    }
}

