/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.md;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.html.HTMLElement;
import org.pageseeder.psml.html.HTMLNode;
import org.pageseeder.psml.md.Configuration;
import org.pageseeder.psml.md.HTMLInlineParser;
import org.pageseeder.psml.md.MarkdownInputOptions;

public class HTMLBlockParser {
    private MarkdownInputOptions options;

    public HTMLBlockParser() {
        this.options = MarkdownInputOptions.defaultFragmentOptions();
    }

    public HTMLBlockParser(MarkdownInputOptions options) {
        this.options = Objects.requireNonNull(options);
    }

    public List<HTMLElement> parse(List<String> lines) {
        return this.parse(lines, this.options);
    }

    @Deprecated(forRemoval=true, since="1.6.1")
    public List<HTMLElement> parse(List<String> lines, Configuration config) {
        return this.parse(lines, config.toMarkdownInputOptions());
    }

    public List<HTMLElement> parse(List<String> lines, MarkdownInputOptions options) {
        State state = new State();
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            String next = i < lines.size() - 1 ? lines.get(i + 1) : null;
            HTMLBlockParser.processLine(line, next, state, options);
        }
        state.commitAll();
        return state.elements;
    }

    public MarkdownInputOptions getOptions() {
        return this.options;
    }

    public void setOptions(MarkdownInputOptions options) {
        this.options = options;
    }

    @Deprecated(forRemoval=true, since="1.6.1")
    public void setConfiguration(Configuration configuration) {
        this.options = configuration.toMarkdownInputOptions();
    }

    @Deprecated(forRemoval=true, since="1.6.1")
    public Configuration getConfiguration() {
        return Configuration.fromMarkdownInputOptions(this.options);
    }

    @Deprecated(forRemoval=true, since="1.6.1")
    public void processLine(String line, @Nullable String next, State state, Configuration config) {
        HTMLBlockParser.processLine(line, next, state, config.toMarkdownInputOptions());
    }

    public static void processLine(String line, @Nullable String next, State state, MarkdownInputOptions options) {
        if (!line.matches("\\s?(==+|--+)\\s*")) {
            if (line.matches("\\s*\\*\\s?\\*\\s?\\*[\\s\\*]*")) {
                if (options.isDocument()) {
                    state.ensureFragment();
                    state.newFragment();
                }
            } else if (line.matches("\\s*") && !state.isFenced()) {
                state.commitUpto(HTMLElement.Name.SECTION);
            } else if (line.matches("\\s*(-|\\+|\\*|\\d+\\.)\\s.+")) {
                HTMLBlockParser.processListItem(line, state, options);
            } else if (state.isInList()) {
                if (options.isDocument()) {
                    state.ensureFragment();
                }
                if (!state.context.isEmpty() && state.text != null) {
                    state.append(line.trim());
                }
            } else if (line.matches("\\s{4}.*") && !state.isFenced()) {
                if (options.isDocument()) {
                    state.ensureFragment();
                }
                if (!state.isElement(HTMLElement.Name.PRE)) {
                    state.commitUpto(HTMLElement.Name.SECTION);
                    state.push(HTMLElement.Name.PRE, line.substring(4));
                } else {
                    state.append(line.substring(4));
                }
            } else if (line.startsWith("```")) {
                HTMLBlockParser.processFencedCode(line, state, options);
            } else if (line.startsWith("~~~")) {
                HTMLBlockParser.processFencedLabel(line, state, options);
            } else if (line.matches("\\s*>+\\s*.*") && !state.isElement(HTMLElement.Name.PRE)) {
                HTMLBlockParser.processQuoteBlock(line, state, options);
            } else if (line.startsWith("|") && !state.isElement(HTMLElement.Name.PRE)) {
                HTMLBlockParser.processTableRow(line, next, state, options);
            } else if (options.isDocument() && !state.isDescendantOf(HTMLElement.Name.SECTION) && line.matches("^\\w+:\\s.*")) {
                HTMLBlockParser.processMetadataDefinition(line, state, options);
            } else {
                if (options.isDocument()) {
                    state.ensureFragment();
                }
                if (state.isElement(HTMLElement.Name.PRE) || state.isElement(HTMLElement.Name.CODE) && state.isDescendantOf(HTMLElement.Name.PRE)) {
                    state.append(line);
                } else {
                    Pattern headingPattern = Pattern.compile("^\\s*(#{1,6})\\s+(.*?)(#{1,6})?$");
                    Matcher m = headingPattern.matcher(line);
                    if (m.matches()) {
                        state.commitUpto(HTMLElement.Name.SECTION);
                        int level = m.group(1).length();
                        String text = m.group(2).trim();
                        HTMLElement heading = HTMLBlockParser.newHeadingElement(level);
                        state.push(heading, text);
                        state.commit();
                    } else {
                        boolean isTitle = false;
                        HTMLElement element = new HTMLElement(HTMLElement.Name.P);
                        if (next != null) {
                            if (next.matches("\\s*==+\\s*")) {
                                HTMLElement section;
                                if (options.isDocument() && !state.current().isEmpty()) {
                                    state.newSection();
                                }
                                element = HTMLBlockParser.newHeadingElement(1);
                                if (options.isDocument() && (section = state.ancestor(HTMLElement.Name.SECTION)) != null && "title".equals(section.getAttribute("id"))) {
                                    isTitle = true;
                                }
                            } else if (next.matches("\\s*--+\\s*")) {
                                if (options.isDocument() && !state.current().isEmpty()) {
                                    state.newFragment();
                                }
                                element = HTMLBlockParser.newHeadingElement(2);
                            }
                        }
                        if (!state.isElement(element.getElement())) {
                            state.commitUpto(HTMLElement.Name.SECTION);
                            state.push(element, line.trim());
                        } else {
                            if (state.lineBreak) {
                                state.lineBreak();
                            }
                            state.append(line.trim());
                        }
                        boolean bl = state.lineBreak = line.length() < options.getLineBreakThreshold();
                        if (isTitle) {
                            state.commitUpto(HTMLElement.Name.ARTICLE);
                        }
                    }
                }
            }
        }
    }

    public static HTMLElement newHeadingElement(int level) {
        switch (level) {
            case 1: {
                return new HTMLElement(HTMLElement.Name.H1);
            }
            case 2: {
                return new HTMLElement(HTMLElement.Name.H2);
            }
            case 3: {
                return new HTMLElement(HTMLElement.Name.H3);
            }
            case 4: {
                return new HTMLElement(HTMLElement.Name.H4);
            }
            case 5: {
                return new HTMLElement(HTMLElement.Name.H5);
            }
            case 6: {
                return new HTMLElement(HTMLElement.Name.H6);
            }
        }
        return new HTMLElement(HTMLElement.Name.P);
    }

    private static void processListItem(String line, State state, MarkdownInputOptions options) {
        Pattern x;
        Matcher m;
        if (options.isDocument()) {
            state.ensureFragment();
        }
        if ((m = (x = Pattern.compile("^\\s*(-|\\+|\\*|\\d+\\.)\\s+(.+)$")).matcher(line)).matches()) {
            String no = m.group(1);
            if (state.isInList()) {
                state.commit();
            } else {
                HTMLElement list;
                state.commitUpto(HTMLElement.Name.SECTION);
                if (no.matches("\\d+\\.")) {
                    list = new HTMLElement(HTMLElement.Name.OL);
                    String initial = no.substring(0, no.length() - 1);
                    if (!"1".equals(initial)) {
                        list.setAttribute("start", initial);
                    }
                } else {
                    list = new HTMLElement(HTMLElement.Name.UL);
                }
                state.push(list);
            }
            state.push(HTMLElement.Name.LI, m.group(2).trim());
        }
    }

    private static void processFencedCode(String line, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        if (state.isElement(HTMLElement.Name.PRE) || state.isElement(HTMLElement.Name.CODE) && state.isDescendantOf(HTMLElement.Name.PRE)) {
            state.setFenced(false);
            state.append("");
            state.commitUpto(HTMLElement.Name.SECTION);
        } else {
            state.commitUpto(HTMLElement.Name.SECTION);
            HTMLElement pre = new HTMLElement(HTMLElement.Name.PRE);
            state.push(pre, "");
            state.setFenced(true);
            if (line.length() > 3) {
                HTMLElement code = new HTMLElement(HTMLElement.Name.CODE);
                String language = line.substring(3).trim();
                if (!language.isEmpty()) {
                    code.setAttribute("class", "lang-" + language);
                }
                state.push(code, "");
            }
        }
    }

    private static void processFencedLabel(String line, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        if (state.isElement(HTMLElement.Name.DIV)) {
            state.commitUpto(HTMLElement.Name.SECTION);
        } else {
            String label;
            state.commitUpto(HTMLElement.Name.SECTION);
            HTMLElement pre = new HTMLElement(HTMLElement.Name.DIV);
            if (line.length() > 3 && !(label = line.substring(3).trim()).isEmpty()) {
                pre.setAttribute("label", label);
                pre.setAttribute("class", "label-" + label);
            }
            state.push(pre, "");
        }
    }

    private static void processQuoteBlock(String line, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        String text = line.substring(line.indexOf(62) + 1).replaceFirst("^\\s+", "");
        HTMLElement current = state.current();
        if (current != null && current.isElement(HTMLElement.Name.BLOCKQUOTE)) {
            HTMLElement lastElement;
            HTMLNode last;
            List<HTMLNode> children = current.getNodes();
            HTMLNode hTMLNode = last = children.isEmpty() ? null : children.get(children.size() - 1);
            if (last instanceof HTMLElement && (lastElement = (HTMLElement)last).isElement(HTMLElement.Name.P)) {
                if (text.matches("\\s*")) {
                    current.addNode(new HTMLElement(HTMLElement.Name.P));
                } else {
                    lastElement.addText((lastElement.getText().isEmpty() ? "" : " ") + text);
                }
            }
        } else {
            state.commitUpto(HTMLElement.Name.SECTION);
            HTMLElement block = new HTMLElement(HTMLElement.Name.BLOCKQUOTE);
            HTMLElement p = new HTMLElement(HTMLElement.Name.P);
            p.setText(text);
            block.addNode(p);
            state.push(block);
        }
    }

    private static void processMetadataDefinition(String line, State state, MarkdownInputOptions options) {
        int colon = line.indexOf(58);
        if (!state.isDescendantOf(HTMLElement.Name.DL)) {
            state.push(HTMLElement.Name.DL);
        }
        state.push(HTMLElement.Name.DT, line.substring(0, colon));
        state.push(HTMLElement.Name.DD, line.substring(colon + 2).trim());
        state.commit();
    }

    private static void processTableRow(String line, @Nullable String next, State state, MarkdownInputOptions options) {
        if (options.isDocument()) {
            state.ensureFragment();
        }
        assert (line.startsWith("|"));
        String[] columns = line.substring(1).split("\\|");
        boolean inTable = state.isDescendantOf(HTMLElement.Name.TABLE);
        boolean isHeaderRow = false;
        if (!inTable && next != null && next.startsWith("|") && next.matches("^\\|([\\s:-]+\\|){" + columns.length + "}")) {
            String[] cols;
            HTMLElement table = new HTMLElement(HTMLElement.Name.TABLE);
            String[] stringArray = cols = next.substring(1).split("\\|");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String col = stringArray[i];
                String align = HTMLBlockParser.toColAlign(col);
                HTMLElement colElement = new HTMLElement(HTMLElement.Name.COL);
                if (align != null) {
                    colElement.setAttribute("align", align);
                }
                table.addNode(colElement);
            }
            state.push(table);
            inTable = true;
            isHeaderRow = true;
        }
        if (inTable) {
            if (!line.matches("^\\|([\\s:-]+\\|){" + columns.length + "}")) {
                HTMLElement row = new HTMLElement(HTMLElement.Name.TR);
                state.push(row);
                for (String col : columns) {
                    String text = col.trim();
                    if (isHeaderRow && text.matches("^\\*\\*(.*)\\*\\*$")) {
                        text = text.substring(2, text.length() - 2);
                    }
                    state.push(isHeaderRow ? HTMLElement.Name.TH : HTMLElement.Name.TD, text);
                    state.commit();
                }
                state.commit();
            }
        } else {
            state.push(HTMLElement.Name.P, line.trim());
        }
    }

    private static @Nullable String toColAlign(String col) {
        String colSpec = col.trim();
        boolean startWithColon = colSpec.startsWith(":");
        boolean endsWithColon = colSpec.endsWith(":");
        if (startWithColon && endsWithColon) {
            return "center";
        }
        if (startWithColon) {
            return "left";
        }
        if (endsWithColon) {
            return "right";
        }
        return null;
    }

    public static final class State {
        private final List<HTMLElement> elements = new ArrayList<HTMLElement>();
        private final HTMLInlineParser inline = new HTMLInlineParser();
        private final List<HTMLElement> context = new ArrayList<HTMLElement>(4);
        private final String[] sectionIds = new String[]{"title", "content"};
        private int sectionPosition = 0;
        private int fragmentId = 0;
        private @Nullable StringBuilder text = null;
        private boolean lineBreak = false;
        private boolean fenced = false;

        public boolean isFenced() {
            return this.fenced;
        }

        public void setFenced(boolean fence) {
            this.fenced = fence;
        }

        public boolean isInList() {
            int size = this.context.size();
            HTMLElement current = size > 0 ? this.context.get(size - 1) : null;
            HTMLElement parent = size > 1 ? this.context.get(size - 2) : null;
            boolean isCurrentList = current != null && (current.isElement(HTMLElement.Name.UL) || current.isElement(HTMLElement.Name.OL));
            boolean isParentList = parent != null && (parent.isElement(HTMLElement.Name.UL) || parent.isElement(HTMLElement.Name.OL));
            return isCurrentList || isParentList;
        }

        public @Nullable HTMLElement current() {
            if (this.context.isEmpty()) {
                return null;
            }
            return this.context.get(this.context.size() - 1);
        }

        public @Nullable HTMLElement ancestor(HTMLElement.Name name) {
            int size = this.context.size();
            if (size == 0) {
                return null;
            }
            for (int i = size - 1; i >= 0; --i) {
                HTMLElement element = this.context.get(i);
                if (element.getElement() != name) continue;
                return element;
            }
            return null;
        }

        public boolean isElement(HTMLElement.Name name) {
            HTMLElement current = this.current();
            return current != null && current.isElement(name);
        }

        public boolean isDescendantOf(HTMLElement.Name name) {
            return this.ancestor(name) != null;
        }

        public void newSection() {
            if (this.sectionPosition < this.sectionIds.length) {
                this.commitAll();
                HTMLElement section = new HTMLElement(HTMLElement.Name.SECTION);
                String sectionId = this.sectionIds[this.sectionPosition];
                section.setAttribute("id", sectionId);
                this.push(section);
                ++this.sectionPosition;
            }
        }

        public void newFragment() {
            this.commitUpto(HTMLElement.Name.SECTION);
            HTMLElement fragment = new HTMLElement(HTMLElement.Name.SECTION);
            fragment.setAttribute("id", ++this.fragmentId);
            this.push(fragment);
        }

        public void ensureFragment() {
            if (!this.isDescendantOf(HTMLElement.Name.ARTICLE)) {
                this.newSection();
            }
            if (!this.isDescendantOf(HTMLElement.Name.SECTION)) {
                this.newFragment();
            }
        }

        public void push(HTMLElement.Name name, String text) {
            this.push(new HTMLElement(name), text);
        }

        public void push(HTMLElement.Name name) {
            this.push(new HTMLElement(name));
        }

        public void push(HTMLElement element) {
            this.context.add(element);
            this.text = null;
        }

        public void push(HTMLElement element, String text) {
            this.context.add(element);
            this.text = new StringBuilder(text);
        }

        public void append(String text) {
            this.text.append('\n').append(text);
        }

        public void commitAll() {
            this.lineBreak = false;
            this.commitText();
            int size = this.context.size();
            while (size > 0) {
                HTMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    HTMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
                size = this.context.size();
            }
        }

        public void commitUpto(HTMLElement.Name name) {
            this.lineBreak = false;
            this.commitText();
            int size = this.context.size();
            while (size > 0 && !this.isElement(name)) {
                HTMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    HTMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
                size = this.context.size();
            }
        }

        public void lineBreak() {
            this.commitText();
            HTMLElement current = this.current();
            if (current != null) {
                current.addNode(new HTMLElement(HTMLElement.Name.BR));
            }
            this.text = new StringBuilder();
        }

        public void commit() {
            this.commitText();
            int size = this.context.size();
            if (size > 0) {
                HTMLElement current = this.context.remove(size - 1);
                if (size > 1) {
                    HTMLElement parent = this.context.get(size - 2);
                    parent.addNode(current);
                } else {
                    this.elements.add(current);
                }
            }
        }

        public void commitText() {
            HTMLElement current = this.current();
            if (this.text != null && current != null) {
                List<HTMLNode> nodes = this.inline.parse(this.text.toString());
                current.addNodes(nodes);
                this.text = null;
            }
        }
    }
}

