/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.action.Operation;
import org.pageseeder.diffx.action.OperationsBuffer;
import org.pageseeder.diffx.algorithm.MatrixXMLAlgorithm;
import org.pageseeder.diffx.api.DiffAlgorithm;
import org.pageseeder.diffx.api.DiffHandler;
import org.pageseeder.diffx.api.Operator;
import org.pageseeder.diffx.handler.XMLBalanceCheckFilter;
import org.pageseeder.diffx.handler.XMLEventBalancer;
import org.pageseeder.diffx.similarity.EditSimilarity;
import org.pageseeder.diffx.similarity.ElementSimilarity;
import org.pageseeder.diffx.similarity.Similarity;
import org.pageseeder.diffx.similarity.SimilarityWagnerFischerAlgorithm;
import org.pageseeder.diffx.similarity.StreamSimilarity;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLElement;
import org.pageseeder.psml.diff.PseudoStartToken;
import org.pageseeder.psml.diff.ShiftLeftFilter;
import org.pageseeder.psml.util.Beta;

@Beta
public final class GasherbrumVAlgorithm
implements DiffAlgorithm<XMLToken> {
    private static final Set<String> DEFAULT_BLOCKS = Set.of("heading", "item", "para", "preformat", "row");
    public static final float DEFAULT_SIMILARITY_THRESHOLD = 0.5f;
    public static final double DEFAULT_LENGTH_BOOST_FACTOR = 0.1;
    private final float similarityThreshold;
    private final Set<String> blocks;
    private boolean hasError = false;

    public GasherbrumVAlgorithm() {
        this.similarityThreshold = 0.5f;
        this.blocks = DEFAULT_BLOCKS;
    }

    public GasherbrumVAlgorithm(float similarityThreshold) {
        this.similarityThreshold = similarityThreshold;
        this.blocks = DEFAULT_BLOCKS;
    }

    public float getSimilarityThreshold() {
        return this.similarityThreshold;
    }

    public Set<String> getBlocks() {
        return this.blocks;
    }

    public void diff(List<? extends XMLToken> from, List<? extends XMLToken> to, DiffHandler<XMLToken> handler) {
        List<XMLToken> gFrom = this.fold(from);
        List<XMLToken> gTo = this.fold(to);
        OperationsBuffer<XMLToken> buffer = this.diffBySimilarity(gFrom, gTo);
        XMLBalanceCheckFilter checker = new XMLBalanceCheckFilter(handler);
        XMLEventBalancer balancer = new XMLEventBalancer((DiffHandler)checker);
        ShiftLeftFilter shifter = new ShiftLeftFilter((DiffHandler<XMLToken>)balancer);
        shifter.start();
        this.diffAndUnfold(gFrom, gTo, buffer, (DiffHandler<XMLToken>)shifter);
        shifter.end();
        if (!checker.isBalanced()) {
            this.hasError = true;
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    private OperationsBuffer<XMLToken> diffBySimilarity(List<XMLToken> from, List<XMLToken> to) {
        SimilarityWagnerFischerAlgorithm algorithm = new SimilarityWagnerFischerAlgorithm((Similarity)new ElementSimilarity((StreamSimilarity)new EditSimilarity(), 0.1), this.similarityThreshold);
        OperationsBuffer buffer = new OperationsBuffer();
        algorithm.diff(from, to, (DiffHandler)buffer);
        return buffer;
    }

    private void diffAndUnfold(List<XMLToken> from, List<XMLToken> to, OperationsBuffer<XMLToken> path, DiffHandler<XMLToken> handler) {
        int i = 0;
        int j = 0;
        for (Operation operation : path.getOperations()) {
            Operator operator = operation.operator();
            XMLToken token = (XMLToken)operation.token();
            if (token.getType() == XMLTokenType.ELEMENT) {
                if (operator == Operator.MATCH) {
                    XMLElement fromElement = (XMLElement)from.get(i);
                    XMLElement toElement = (XMLElement)to.get(j);
                    this.diffElement(fromElement, toElement, operator, handler);
                } else {
                    for (XMLToken t : ((XMLElement)token).tokens()) {
                        handler.handle(operator, (Object)t);
                    }
                }
            } else {
                handler.handle(operator, (Object)token);
            }
            if (operator == Operator.MATCH || operator == Operator.INS) {
                ++j;
            }
            if (operator != Operator.MATCH && operator != Operator.DEL) continue;
            ++i;
        }
    }

    void diffElement(XMLElement from, XMLElement to, Operator operator, DiffHandler<XMLToken> handler) {
        boolean recurse = this.hasMultipleOrDifferentBlocks(from, to);
        if (recurse) {
            handler.handle(operator, (Object)from.getStart());
            this.diff(from.getContent(), to.getContent(), handler);
            handler.handle(operator, (Object)from.getEnd());
        } else {
            MatrixXMLAlgorithm matrix = new MatrixXMLAlgorithm();
            Operator op = this.getOp(from.getStart(), to.getStart());
            if (op != null) {
                handler.handle(op, (Object)from.getStart());
            }
            matrix.diff(from.getContent(), to.getContent(), handler);
            if (op != null) {
                handler.handle(op, (Object)from.getEnd());
            }
        }
    }

    private @Nullable Operator getOp(StartElementToken from, StartElementToken to) {
        boolean fromIsPseudo = from instanceof PseudoStartToken;
        boolean toIsPseudo = to instanceof PseudoStartToken;
        if (fromIsPseudo) {
            return toIsPseudo ? null : Operator.INS;
        }
        return toIsPseudo ? Operator.DEL : Operator.MATCH;
    }

    private List<XMLToken> fold(List<? extends XMLToken> in) {
        ArrayDeque<XMLToken> stack = new ArrayDeque<XMLToken>();
        ArrayList<XMLToken> out = new ArrayList<XMLToken>();
        ArrayList<XMLToken> children = null;
        for (XMLToken xMLToken : in) {
            if (children != null) {
                if (xMLToken.getType() == XMLTokenType.END_ELEMENT && this.isBlock(xMLToken) && stack.size() == 1 && ((XMLToken)stack.peek()).getName().equals(xMLToken.getName())) {
                    StartElementToken start = (StartElementToken)stack.pop();
                    EndElementToken end = (EndElementToken)xMLToken;
                    out.add((XMLToken)new XMLElement(start, end, children));
                    children = null;
                    continue;
                }
                if (xMLToken.getType() == XMLTokenType.START_ELEMENT) {
                    stack.push(xMLToken);
                } else if (xMLToken.getType() == XMLTokenType.END_ELEMENT) {
                    stack.pop();
                }
                children.add(xMLToken);
                continue;
            }
            if (xMLToken.getType() == XMLTokenType.START_ELEMENT && this.isBlock(xMLToken)) {
                children = new ArrayList<XMLToken>();
                stack.push(xMLToken);
                continue;
            }
            out.add(xMLToken);
        }
        return out;
    }

    private boolean hasMultipleOrDifferentBlocks(XMLElement from, XMLElement to) {
        if (from.getContent().size() <= 2 || to.getContent().size() <= 2) {
            return false;
        }
        String fromBlock = this.findFirstBlock(from);
        if (fromBlock == null) {
            return false;
        }
        if (fromBlock.isEmpty()) {
            return true;
        }
        String toBlock = this.findFirstBlock(to);
        if (toBlock == null) {
            return false;
        }
        if (toBlock.isEmpty()) {
            return true;
        }
        return !fromBlock.equals(toBlock);
    }

    private @Nullable String findFirstBlock(XMLElement element) {
        String firstBlock = null;
        for (XMLToken t : element.getContent()) {
            if (t.getType() != XMLTokenType.START_ELEMENT) continue;
            if (this.isBlock(t)) {
                if (firstBlock == null) {
                    firstBlock = t.getName();
                    continue;
                }
                return "";
            }
            if (!this.isCell(t)) continue;
            firstBlock = null;
        }
        return firstBlock;
    }

    private boolean isBlock(XMLToken token) {
        return token.getNamespaceURI().isEmpty() && this.blocks.contains(token.getName());
    }

    private boolean isCell(XMLToken token) {
        return token.getName().matches("cell|hcell");
    }
}

