/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.util.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class CompareHandler
extends DefaultHandler {
    private @Nullable Writer xml = null;
    private final Deque<String> elements = new ArrayDeque<String>();
    private @Nullable String fragmentId = null;
    private final Map<String, String> compareFragments = new HashMap<String, String>();

    public Map<String, String> getCompareFragments() {
        return this.compareFragments;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if ("document".equals(qName) && !"portable".equals(atts.getValue("level"))) {
            throw new SAXException("Diff is only supported for PSML with level=\"portable\"");
        }
        if (this.isFragment(qName)) {
            if ("content".equals(this.elements.peek())) {
                this.compareFragments.put(atts.getValue("id"), "");
            } else if (this.compareFragments.get(atts.getValue("id")) != null) {
                this.fragmentId = atts.getValue("id");
                this.xml = new StringWriter();
            }
        }
        if (this.xml != null) {
            try {
                this.xml.write("<" + qName);
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + qName, ex);
            }
            for (int i = 0; i < atts.getLength(); ++i) {
                String name = atts.getQName(i);
                String value = atts.getValue(i);
                try {
                    this.xml.write(" " + name + "=\"" + XMLUtils.escapeForAttribute(value) + "\"");
                    continue;
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to add attribute \"" + atts.getQName(i) + "\" to element " + qName, ex);
                }
            }
            try {
                this.xml.write(">");
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + qName, ex);
            }
        }
        this.elements.push(qName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.pop();
        try {
            if (this.xml != null) {
                this.xml.write("</" + qName + ">");
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to close element " + qName, ex);
        }
        if (this.isFragment(qName) && !"content".equals(this.elements.peek()) && this.fragmentId != null) {
            assert (this.xml != null);
            this.compareFragments.put(this.fragmentId, this.xml.toString());
            this.xml = null;
            this.fragmentId = null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            if (this.xml != null) {
                this.xml.write(XMLUtils.escape(new String(ch, start, length)));
            }
        }
        catch (IOException ex) {
            throw new SAXException("Failed to write text", ex);
        }
    }

    private boolean isFragment(String qName) {
        return "fragment".equals(qName) || "media-fragment".equals(qName) || "xref-fragment".equals(qName) || "properties-fragment".equals(qName);
    }
}

