/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.psml.diff;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.diffx.token.EndElementToken;
import org.pageseeder.diffx.token.StartElementToken;
import org.pageseeder.diffx.token.XMLToken;
import org.pageseeder.diffx.token.XMLTokenType;
import org.pageseeder.diffx.token.impl.XMLEndElement;
import org.pageseeder.diffx.token.impl.XMLStartElement;
import org.pageseeder.diffx.xml.SequenceProcessor;
import org.pageseeder.psml.diff.PseudoEndToken;
import org.pageseeder.psml.diff.PseudoStartToken;

final class BlockLabelNormalizer
implements SequenceProcessor {
    private final String para;
    private final Set<String> blocks;
    private final Set<String> containers;

    public static BlockLabelNormalizer forHtml() {
        return new BlockLabelNormalizer("p", Set.of("div"), Set.of("p", "ol", "ul", "div", "h1", "h2", "h3", "h4", "h5", "h6", "table", "pre"));
    }

    public static BlockLabelNormalizer forPsml() {
        return new BlockLabelNormalizer("para", Set.of("block"), Set.of("para", "list", "nlist", "block", "heading", "table", "preformat"));
    }

    BlockLabelNormalizer(String name, Set<String> blocks, Set<String> containers) {
        this.para = name;
        this.blocks = blocks;
        this.containers = containers;
    }

    public List<XMLToken> process(List<XMLToken> tokens) {
        State state = new State(this.para, this.blocks, tokens.size());
        for (XMLToken token : tokens) {
            if (token.getType() == XMLTokenType.TEXT) {
                if (state.isBlock() && !token.isWhitespace()) {
                    state.startPseudoPara();
                }
            } else if (token.getType() == XMLTokenType.START_ELEMENT) {
                if (this.isContainer(token)) {
                    if (state.isPseudoPara()) {
                        state.endPseudoPara();
                    }
                } else if (state.isBlock()) {
                    state.startPseudoPara();
                }
                state.push(token);
            } else if (token.getType() == XMLTokenType.END_ELEMENT) {
                if (state.isBlock(token) && state.isPseudoPara()) {
                    state.endPseudoPara();
                }
                state.pop();
            }
            state.target.add(token);
        }
        return state.target;
    }

    private boolean isContainer(@Nullable XMLToken token) {
        if (token == null) {
            return false;
        }
        return this.containers.contains(token.getName());
    }

    private static class State {
        final StartElementToken para;
        final Deque<XMLToken> context = new ArrayDeque<XMLToken>();
        final ArrayList<XMLToken> target;
        final Set<String> blocks;

        public State(String para, Set<String> blocks, int size) {
            this.para = new XMLStartElement(para);
            this.blocks = blocks;
            this.target = new ArrayList(size);
        }

        boolean isBlock() {
            return this.isBlock(this.context.peek());
        }

        private boolean isBlock(@Nullable XMLToken token) {
            return token != null && this.blocks.contains(token.getName());
        }

        boolean isPseudoPara() {
            return this.isPseudoPara(this.context.peek());
        }

        private boolean isPseudoPara(@Nullable XMLToken token) {
            return token != null && this.para.getName().equals(token.getName()) && token instanceof PseudoStartToken;
        }

        void startPseudoPara() {
            PseudoStartToken start = new PseudoStartToken(this.para);
            this.target.add((XMLToken)start);
            this.context.push((XMLToken)start);
        }

        void endPseudoPara() {
            this.target.add((XMLToken)new PseudoEndToken((EndElementToken)new XMLEndElement(this.para)));
            this.context.pop();
        }

        public void push(XMLToken token) {
            this.context.push(token);
        }

        public void pop() {
            this.context.pop();
        }
    }
}

