/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.xml;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.xml.IllegalCloseElementException;
import org.pageseeder.berlioz.xml.UnclosedElementException;
import org.pageseeder.berlioz.xml.XmlWritable;
import org.pageseeder.berlioz.xml.XmlWriteFailureException;
import org.pageseeder.berlioz.xml.XmlWriter;

public class XmlAppendable<T extends Appendable>
implements XmlWriter {
    private static final Element ROOT = new Element("", true);
    final T _xml;
    final String _encoding = "utf-8";
    boolean indent;
    private final @Nullable String _indentChars;
    private final List<Element> _elements = new ArrayList<Element>();
    int depth = 0;
    boolean isNude = false;

    protected XmlAppendable(T xml, @Nullable String indentChars) throws NullPointerException {
        this._xml = (Appendable)Objects.requireNonNull(xml, "XmlWriter cannot use a null writer.");
        this.indent = indentChars != null;
        this._indentChars = indentChars;
        this._elements.add(ROOT);
    }

    public XmlAppendable(T xml) throws NullPointerException {
        this(xml, null);
    }

    public XmlAppendable<T> withIndent(String spaces) {
        if (spaces != null) {
            for (int i = 0; i < spaces.length(); ++i) {
                if (Character.isSpaceChar(spaces.charAt(i))) continue;
                throw new IllegalArgumentException("Not a valid indentation string.");
            }
        }
        return new XmlAppendable<T>(this._xml, spaces);
    }

    @Override
    public final XmlAppendable<T> text(String text) {
        return this.text(text.toCharArray(), 0, text.length());
    }

    @Override
    public final XmlAppendable<T> text(long number) {
        this.deNude();
        try {
            this._xml.append(Long.toString(number));
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> text(double number) {
        this.deNude();
        try {
            this._xml.append(Double.toString(number));
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> text(char[] text, int off, int len) {
        this.deNude();
        try {
            char c = ' ';
            for (int i = off; i < off + len; ++i) {
                c = text[i];
                if (c == '<') {
                    this._xml.append("&lt;");
                    continue;
                }
                if (c == '>') {
                    this._xml.append("&gt;");
                    continue;
                }
                if (c == '&') {
                    this._xml.append("&amp;");
                    continue;
                }
                if (c == '\n' || c == '\r' || c == '\t') {
                    this._xml.append(c);
                    continue;
                }
                if (c < 32 || c >= '\u007f' && c < '\u00a0') continue;
                if (c >= '\ud800' && c <= '\udfff') {
                    int codePoint = Character.codePointAt(text, i, len);
                    i += Character.charCount(codePoint) - 1;
                    this._xml.append("&#x");
                    this._xml.append(Integer.toHexString(codePoint));
                    this._xml.append(";");
                    continue;
                }
                this._xml.append(c);
            }
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> text(char c) {
        this.deNude();
        try {
            if (c == '<') {
                this._xml.append("&lt;");
            } else if (c == '>') {
                this._xml.append("&gt;");
            } else if (c == '&') {
                this._xml.append("&amp;");
            } else if (c == '\n' || c == '\r' || c == '\t') {
                this._xml.append(c);
            } else if (c >= ' ' && (c < '\u007f' || c >= '\u00a0')) {
                this._xml.append(c);
            }
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    public XmlAppendable<T> asText(@Nullable Object o) {
        this.text(o != null ? o.toString() : "null");
        return this;
    }

    public XmlAppendable<T> asXml(@Nullable Object o) {
        return this;
    }

    @Override
    public final XmlAppendable<T> xml(String xml) {
        this.deNude();
        this.append(xml);
        return this;
    }

    @Override
    public final XmlAppendable<T> xml(char[] xml, int off, int len) {
        this.deNude();
        for (int i = off; i < off + len; ++i) {
            this.append(xml[i]);
        }
        return this;
    }

    @Override
    public XmlAppendable<T> asXml(XmlWritable object) {
        object.toXml(this);
        return this;
    }

    @Override
    public final void declaration() {
        this.append("<?xml version=\"1.0\" encoding=\"" + this._encoding + "\"?>");
        if (this.indent) {
            this.append('\n');
        }
    }

    @Override
    public final XmlAppendable<T> comment(String comment) throws IllegalArgumentException {
        if (comment.indexOf("--") >= 0) {
            throw new IllegalArgumentException("A comment must not contain '--'.");
        }
        this.deNude();
        this.append("<!-- ");
        this.append(comment);
        this.append(" -->");
        if (this.indent) {
            this.append('\n');
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> processingInstruction(String target, @Nullable String data) {
        this.deNude();
        try {
            this._xml.append("<?");
            this._xml.append(target);
            this._xml.append(' ');
            this._xml.append(data);
            this._xml.append("?>");
            if (this.indent) {
                this._xml.append('\n');
            }
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> cdata(String data) {
        String end = "]]>";
        if (data.indexOf("]]>") >= 0) {
            throw new IllegalArgumentException("CDATA sections must not contain ']]>'");
        }
        this.deNude();
        try {
            this._xml.append("<![CDATA[");
            this._xml.append(data);
            this._xml.append("]]>");
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public XmlAppendable<T> attributes(Map<String, String> map) {
        for (Map.Entry<String, String> attr : map.entrySet()) {
            this.attribute(attr.getKey(), attr.getValue());
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> attribute(String name, String value) {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        try {
            this._xml.append(' ');
            this._xml.append(name);
            this._xml.append('=');
            this._xml.append('\"');
            this.appendAttrValue(value.toCharArray(), 0, value.length());
            this._xml.append('\"');
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public final XmlAppendable<T> attribute(String name, double value) {
        return this.appendRawAttr(name, Double.toString(value));
    }

    @Override
    public XmlAppendable<T> attribute(String name, long value) {
        return this.appendRawAttr(name, Long.toString(value));
    }

    @Override
    public XmlAppendable<T> attribute(String name, boolean value) {
        return this.appendRawAttr(name, Boolean.toString(value));
    }

    private final XmlAppendable<T> appendRawAttr(String name, String value) {
        if (!this.isNude) {
            throw new IllegalStateException("Cannot write attribute: too late!");
        }
        try {
            this._xml.append(' ');
            this._xml.append(name);
            this._xml.append('=');
            this._xml.append('\"');
            this._xml.append(value);
            this._xml.append('\"');
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public XmlAppendable<T> openElement(String name) {
        return this.openElement(name, false);
    }

    @Override
    public XmlAppendable<T> openElement(String name, boolean hasChildren) {
        this.deNude();
        if (this.peekElement().hasChildren) {
            this.indent();
        }
        this._elements.add(new Element(name, hasChildren));
        this.append('<');
        this.append(name);
        this.isNude = true;
        ++this.depth;
        return this;
    }

    @Override
    public XmlAppendable<T> closeElement() throws IllegalCloseElementException {
        Element parent;
        Element elt = this.popElement();
        if (elt == ROOT) {
            throw new IllegalCloseElementException();
        }
        --this.depth;
        if (this.isNude) {
            this.append('/');
            this.isNude = false;
        } else {
            if (elt.hasChildren) {
                this.indent();
            }
            this.append('<');
            this.append('/');
            int x = elt.name.indexOf(32);
            if (x < 0) {
                this.append(elt.name);
            } else {
                this.append(elt.name.substring(0, x));
            }
        }
        this.append('>');
        if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
            this.append('\n');
        }
        return this;
    }

    @Override
    public XmlAppendable<T> emptyElement(String element) {
        Element parent;
        this.deNude();
        this.indent();
        this.append('<');
        this.append(element);
        this.append('/');
        this.append('>');
        if (this.indent && (parent = this.peekElement()).hasChildren && parent != ROOT) {
            this.append('\n');
        }
        return this;
    }

    @Override
    public XmlAppendable<T> element(String name, String text) {
        return ((XmlAppendable)((XmlAppendable)this.openElement(name)).text(text)).closeElement();
    }

    @Override
    public XmlAppendable<T> element(String name, long text) {
        return ((XmlAppendable)((XmlAppendable)this.openElement(name)).xml(Long.toString(text))).closeElement();
    }

    @Override
    public XmlAppendable<T> element(String name, double text) {
        return ((XmlAppendable)((XmlAppendable)this.openElement(name)).xml(Double.toString(text))).closeElement();
    }

    private Element peekElement() {
        return this._elements.get(this._elements.size() - 1);
    }

    private Element popElement() {
        return this._elements.remove(this._elements.size() - 1);
    }

    @Override
    public void close() throws UnclosedElementException {
        Element open = this.peekElement();
        if (open != ROOT) {
            throw new UnclosedElementException(open.name);
        }
        if (this._xml instanceof Closeable) {
            try {
                ((Closeable)this._xml).close();
            }
            catch (IOException ex) {
                throw new XmlWriteFailureException(ex);
            }
        }
    }

    @Override
    public void flush() {
        if (this._xml instanceof Flushable) {
            try {
                ((Flushable)this._xml).flush();
            }
            catch (IOException ex) {
                throw new XmlWriteFailureException(ex);
            }
        }
    }

    private void deNude() {
        if (this.isNude) {
            this.append('>');
            if (this.peekElement().hasChildren && this.indent) {
                this.append('\n');
            }
            this.isNude = false;
        }
    }

    void indent() {
        String spaces = this._indentChars;
        if (this.indent && spaces != null) {
            for (int i = 0; i < this.depth; ++i) {
                this.append(spaces);
            }
        }
    }

    private void appendAttrValue(char[] ch, int off, int len) {
        try {
            for (int i = off; i < off + len; ++i) {
                char c = ch[i];
                if (c == '<') {
                    this._xml.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    this._xml.append("&amp;");
                    continue;
                }
                if (c == '\"') {
                    this._xml.append("&quot;");
                    continue;
                }
                if (c == '\'') {
                    this._xml.append("&#39;");
                    continue;
                }
                if (c == '\n' || c == '\r' || c == '\t') {
                    this._xml.append(c);
                    continue;
                }
                if (c < ' ' || c >= '\u007f' && c < '\u00a0') continue;
                if (c >= '\ud800' && c <= '\udfff') {
                    int codePoint = Character.codePointAt(ch, i, len);
                    i += Character.charCount(codePoint) - 1;
                    this._xml.append("&#x");
                    this._xml.append(Integer.toHexString(codePoint));
                    this._xml.append(";");
                    continue;
                }
                this._xml.append(c);
            }
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
    }

    private final Appendable append(CharSequence csq) throws XmlWriteFailureException {
        try {
            return this._xml.append(csq);
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
    }

    private final Appendable append(char c) throws XmlWriteFailureException {
        try {
            return this._xml.append(c);
        }
        catch (IOException ex) {
            throw new XmlWriteFailureException(ex);
        }
    }

    private static final class Element {
        private final String name;
        private final boolean hasChildren;

        public Element(String name, boolean hasChildren) {
            this.name = name;
            this.hasChildren = hasChildren;
        }
    }
}

