/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CharsetUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CharsetUtils.class);

    private CharsetUtils() {
    }

    public static int length(CharSequence content, Charset charset) {
        int length;
        Objects.requireNonNull(content, "No length for null content");
        Objects.requireNonNull(charset, "Charset is null");
        try {
            CharsetEncoder encoder = charset.newEncoder();
            ByteBuffer bytes = encoder.encode(CharBuffer.wrap(content));
            length = bytes.limit();
        }
        catch (CharacterCodingException ex) {
            LOGGER.error("Unable to determine the length of specified content", (Throwable)ex);
            length = -1;
        }
        return length;
    }
}

