/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.content.GeneratorListener;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.util.ISO8601;
import org.pageseeder.xmlwriter.XMLWritable;
import org.pageseeder.xmlwriter.XMLWriter;

final class StatisticsCollector
implements GeneratorListener,
XMLWritable {
    private static final StatisticsCollector SINGLETON = new StatisticsCollector();
    private final ConcurrentHashMap<Class<?>, BasicStats> _stats = new ConcurrentHashMap();
    private long since = System.currentTimeMillis();

    private StatisticsCollector() {
    }

    @Override
    public void generate(Service service, ContentGenerator generator, ContentStatus status, long etag, long process) {
        BasicStats basic = this._stats.get(generator.getClass());
        if (basic == null) {
            basic = new BasicStats(generator.getClass().getName(), status, etag, process);
            this._stats.put(generator.getClass(), basic);
        } else {
            basic.update(status, etag, process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this._stats.clear();
        StatisticsCollector statisticsCollector = this;
        synchronized (statisticsCollector) {
            this.since = System.currentTimeMillis();
        }
    }

    public static StatisticsCollector getInstance() {
        return SINGLETON;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("statistics");
        xml.attribute("since", ISO8601.format(this.since, ISO8601.DATETIME));
        for (BasicStats s : this._stats.values()) {
            s.toXML(xml);
        }
        xml.closeElement();
    }

    public static final class BasicStats
    implements XMLWritable {
        private final String _generator;
        private final Map<ContentStatus, AtomicLong> _status;
        private final AtomicLong _count;
        private final AtomicLong _totalEtagTime;
        private final AtomicLong _totalProcessTime;
        private final AtomicLong _minEtagTime;
        private final AtomicLong _minProcessTime;
        private final AtomicLong _maxEtagTime;
        private final AtomicLong _maxProcessTime;
        private final LinkedBlockingDeque<Long> _lastEtag = new LinkedBlockingDeque(10);
        private final LinkedBlockingDeque<Long> _lastProcess = new LinkedBlockingDeque(10);

        private BasicStats(String name, ContentStatus status, long etag, long process) {
            this._generator = name;
            this._status = Collections.synchronizedMap(new EnumMap(ContentStatus.class));
            this._status.put(status, new AtomicLong(1L));
            this._count = new AtomicLong(1L);
            long e = etag / 1000L;
            this._minEtagTime = new AtomicLong(e);
            this._maxEtagTime = new AtomicLong(e);
            this._totalEtagTime = new AtomicLong(e);
            long p = process / 1000L;
            this._minProcessTime = new AtomicLong(p);
            this._maxProcessTime = new AtomicLong(p);
            this._totalProcessTime = new AtomicLong(p);
        }

        public synchronized void update(ContentStatus status, long etag, long process) {
            AtomicLong i = this._status.get((Object)status);
            if (i == null) {
                this._status.put(status, new AtomicLong(1L));
            } else {
                i.incrementAndGet();
            }
            this._count.incrementAndGet();
            long e = etag / 1000L;
            long p = process / 1000L;
            if (e > this._maxEtagTime.get()) {
                this._maxEtagTime.set(e);
            }
            if (e < this._minEtagTime.get()) {
                this._minEtagTime.set(e);
            }
            if (p > this._maxProcessTime.get()) {
                this._maxProcessTime.set(p);
            }
            if (p < this._minProcessTime.get()) {
                this._minProcessTime.set(p);
            }
            this._totalEtagTime.addAndGet(e);
            this._totalProcessTime.addAndGet(p);
            if (this._lastEtag.remainingCapacity() == 0) {
                this._lastEtag.pollFirst();
            }
            this._lastEtag.offerLast(e);
            if (this._lastProcess.remainingCapacity() == 0) {
                this._lastProcess.pollFirst();
            }
            this._lastProcess.offerLast(p);
        }

        public synchronized void toXML(XMLWriter xml) throws IOException {
            xml.openElement("statistic");
            xml.attribute("generator", this._generator);
            xml.attribute("count", this._count.toString());
            xml.attribute("min-etag", this._minEtagTime.toString());
            xml.attribute("min-process", this._minProcessTime.toString());
            xml.attribute("max-etag", this._maxEtagTime.toString());
            xml.attribute("max-process", this._maxProcessTime.toString());
            xml.attribute("total-etag", this._totalEtagTime.toString());
            xml.attribute("total-process", this._totalProcessTime.toString());
            long avgEtag = this._totalEtagTime.longValue() / this._count.longValue();
            long avgProcess = this._totalProcessTime.longValue() / this._count.longValue();
            xml.attribute("avg-etag", Long.toString(avgEtag));
            xml.attribute("avg-process", Long.toString(avgProcess));
            long avgLastEtag = BasicStats.average(this._lastEtag);
            long avgLastProcess = BasicStats.average(this._lastProcess);
            xml.attribute("avg-last-etag", Long.toString(avgLastEtag));
            xml.attribute("avg-last-process", Long.toString(avgLastProcess));
            xml.openElement("status");
            for (Map.Entry<ContentStatus, AtomicLong> status : this._status.entrySet()) {
                xml.attribute(status.getKey().name().toLowerCase(), Long.toString(status.getValue().get()));
            }
            xml.closeElement();
            xml.closeElement();
        }

        private static long average(Collection<Long> times) {
            if (times.isEmpty()) {
                return 0L;
            }
            long avgLastEtag = 0L;
            for (Long t : times) {
                avgLastEtag += t.longValue();
            }
            return avgLastEtag / (long)times.size();
        }
    }
}

