/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.system.Threads;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class ListThreads
implements ContentGenerator {
    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        ThreadMXBean bean;
        boolean stacktraces = "true".equals(req.getParameter("stacktraces"));
        boolean threadtime = "true".equals(req.getParameter("threadtime"));
        ThreadMXBean threadMXBean = bean = threadtime ? ManagementFactory.getThreadMXBean() : null;
        if (bean != null && !bean.isThreadCpuTimeSupported()) {
            bean = null;
        }
        xml.openElement("threads");
        if (stacktraces) {
            Map<Thread, StackTraceElement[]> all = Thread.getAllStackTraces();
            for (Map.Entry<Thread, StackTraceElement[]> e : all.entrySet()) {
                ListThreads.toXML(e.getKey(), e.getValue(), bean, xml);
            }
        } else {
            ThreadGroup root = Threads.getRootThreadGroup();
            ListThreads.toXML(root, bean, xml);
        }
        xml.closeElement();
    }

    private static void toXML(ThreadGroup group, @Nullable ThreadMXBean bean, XMLWriter xml) throws IOException {
        Thread[] threads = new Thread[group.activeCount()];
        while (group.enumerate(threads, true) == threads.length) {
            threads = new Thread[threads.length * 2];
        }
        for (Thread t : threads) {
            if (t == null) continue;
            xml.openElement("thread", true);
            xml.attribute("id", Long.toString(t.getId()));
            xml.attribute("name", t.getName());
            xml.attribute("priority", t.getPriority());
            xml.attribute("state", t.getState().name());
            xml.attribute("alive", Boolean.toString(t.isAlive()));
            xml.attribute("daemon", Boolean.toString(t.isDaemon()));
            xml.attribute("group", Threads.toThreadGroupName(t));
            if (t == Thread.currentThread()) {
                xml.attribute("current", "true");
            }
            if (bean != null) {
                long _cpu = bean.getThreadCpuTime(t.getId());
                long _user = bean.getThreadUserTime(t.getId());
                xml.openElement("times");
                xml.attribute("cpu", Long.toString(_cpu));
                xml.attribute("user", Long.toString(_user));
                xml.attribute("system", Long.toString(_cpu - _user));
                xml.closeElement();
            }
            xml.closeElement();
        }
    }

    private static void toXML(Thread thread, StackTraceElement[] stacktrace, @Nullable ThreadMXBean bean, XMLWriter xml) throws IOException {
        xml.openElement("thread", true);
        xml.attribute("id", Long.toString(thread.getId()));
        xml.attribute("name", thread.getName());
        xml.attribute("priority", thread.getPriority());
        xml.attribute("state", thread.getState().name());
        xml.attribute("alive", Boolean.toString(thread.isAlive()));
        xml.attribute("daemon", Boolean.toString(thread.isDaemon()));
        xml.attribute("group", Threads.toThreadGroupName(thread));
        if (thread == Thread.currentThread()) {
            xml.attribute("current", "true");
        }
        if (bean != null) {
            long cpu = bean.getThreadCpuTime(thread.getId());
            long user = bean.getThreadUserTime(thread.getId());
            xml.openElement("time");
            xml.attribute("cpu", Long.toString(cpu));
            xml.attribute("user", Long.toString(user));
            xml.attribute("system", Long.toString(cpu - user));
            xml.closeElement();
        }
        if (stacktrace != null) {
            xml.openElement("stacktrace");
            for (StackTraceElement element : stacktrace) {
                xml.openElement("element");
                String method = element.getMethodName();
                String filename = element.getFileName();
                int line = element.getLineNumber();
                xml.attribute("class", element.getClassName());
                if (filename != null) {
                    xml.attribute("filename", filename);
                }
                if (method != null) {
                    xml.attribute("method", method);
                }
                if (line >= 0) {
                    xml.attribute("line", line);
                }
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.closeElement();
    }
}

