/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.berlioz.BerliozException;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.servlet.HttpContentRequest;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class ListLibraries
implements ContentGenerator {
    private final Map<String, Map<String, String>> _manifest = ListLibraries.createLRUMap(100);

    @Override
    public void process(ContentRequest req, XMLWriter xml) throws BerliozException, IOException {
        HttpServletRequest http = ((HttpContentRequest)req).getHttpRequest();
        ServletContext context = http.getServletContext();
        this.extractLibs(context, xml);
    }

    private void extractLibs(ServletContext context, XMLWriter xml) throws IOException {
        Set paths = context.getResourcePaths("/WEB-INF/lib");
        xml.openElement("libraries");
        if (paths != null) {
            for (String path : paths) {
                String filename = path.indexOf(47) >= 0 ? path.substring(path.lastIndexOf(47)) : path;
                int dot = filename.lastIndexOf(46);
                int dash = filename.lastIndexOf(45);
                String name = dash != -1 ? filename.substring(0, dash) : filename.substring(0, dot);
                String version = dash != -1 ? filename.substring(dash + 1, dot) : null;
                xml.openElement("library");
                xml.attribute("file", filename);
                xml.attribute("name", name);
                if (version != null) {
                    xml.attribute("version", version);
                }
                Map<String, String> attributes = this.getMainAttributes(path, context);
                ListLibraries.toXML(xml, attributes);
                xml.closeElement();
            }
        }
        xml.closeElement();
    }

    private Map<String, String> getMainAttributes(String path, ServletContext context) {
        Map<String, String> attributes = this._manifest.get(path);
        if (attributes == null) {
            attributes = ListLibraries.loadMainAttributes(path, context);
            this._manifest.put(path, attributes);
        }
        return attributes;
    }

    private static Map<String, String> loadMainAttributes(String path, ServletContext context) {
        HashMap<String, String> m;
        block28: {
            m = new HashMap<String, String>();
            try (InputStream in = context.getResourceAsStream(path);){
                if (in == null) break block28;
                try (JarInputStream jar = new JarInputStream(in);){
                    Manifest manifest = jar.getManifest();
                    if (manifest != null) {
                        Attributes attributes = manifest.getMainAttributes();
                        for (Map.Entry<Object, Object> e : attributes.entrySet()) {
                            String key = e.getKey().toString().toLowerCase();
                            Object o = e.getValue();
                            if (o == null) continue;
                            m.put(key, o.toString());
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return m;
    }

    private static void toXML(XMLWriter xml, Map<String, String> attributes) throws IOException {
        HashMap<String, List> keys = new HashMap<String, List>();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String key = entry.getKey();
            int dash = key.indexOf(45);
            if (dash == -1) {
                xml.attribute(key.toLowerCase(), Objects.toString(entry.getValue(), ""));
                continue;
            }
            String category = key.substring(0, dash);
            String value = key.substring(dash + 1);
            List values = keys.computeIfAbsent(category, k -> new ArrayList());
            values.add(value);
        }
        for (Map.Entry<String, String> entry : keys.entrySet()) {
            xml.openElement(entry.getKey().toLowerCase());
            for (String key : (List)((Object)entry.getValue())) {
                String value = attributes.get(entry.getKey() + '-' + key);
                xml.attribute(key.toLowerCase(), Objects.toString(value, ""));
            }
            xml.closeElement();
        }
    }

    private static <K, V> Map<K, V> createLRUMap(final int maxEntries) {
        return new LinkedHashMap<K, V>(maxEntries * 10 / 7, 0.7f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > maxEntries;
            }
        };
    }
}

