/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.system.Threads;
import org.pageseeder.xmlwriter.XMLWriter;

@Beta
public final class GetThreadInfo
implements ContentGenerator {
    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        long threadId = req.getLongParameter("id", -1L);
        if (threadId < 0L) {
            req.setStatus(ContentStatus.BAD_REQUEST);
            xml.writeComment("Interval must be strictly positive");
            return;
        }
        threadId = Thread.currentThread().getId();
        Thread thread = Threads.getThread(threadId);
        if (thread != null) {
            GetThreadInfo.toXML(thread, xml);
        } else {
            xml.openElement("no-thread", true);
            xml.attribute("id", Long.toString(threadId));
            xml.closeElement();
        }
    }

    private static void toXML(Thread thread, XMLWriter xml) throws IOException {
        xml.openElement("thread", true);
        xml.attribute("id", Long.toString(thread.getId()));
        xml.attribute("name", thread.getName());
        xml.attribute("priority", thread.getPriority());
        xml.attribute("state", thread.getState().name());
        xml.attribute("alive", Boolean.toString(thread.isAlive()));
        xml.attribute("daemon", Boolean.toString(thread.isDaemon()));
        xml.attribute("group", Threads.toThreadGroupName(thread));
        StackTraceElement[] stacktrace = thread.getStackTrace();
        if (stacktrace != null) {
            xml.openElement("stacktrace");
            for (StackTraceElement element : stacktrace) {
                xml.openElement("element");
                String method = element.getMethodName();
                String filename = element.getFileName();
                int line = element.getLineNumber();
                xml.attribute("class", element.getClassName());
                if (filename != null) {
                    xml.attribute("filename", filename);
                }
                if (method != null) {
                    xml.attribute("method", method);
                }
                if (line >= 0) {
                    xml.attribute("line", line);
                }
                xml.closeElement();
            }
            xml.closeElement();
        }
        xml.closeElement();
    }
}

