/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.system;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.xmlwriter.XMLWriter;

public final class GetCPUTime
implements ContentGenerator {
    @Override
    public void process(ContentRequest req, XMLWriter xml) throws IOException {
        int interval = req.getIntParameter("interval", 100);
        if (interval <= 0) {
            req.setStatus(ContentStatus.BAD_REQUEST);
            xml.writeComment("Interval must be strictly positive");
            return;
        }
        long threadId = -1L;
        try {
            threadId = req.getLongParameter("thread", -1L);
        }
        catch (NumberFormatException ex) {
            req.setStatus(ContentStatus.BAD_REQUEST);
            xml.writeComment("Invalid thread ID");
            return;
        }
        try {
            Sample end;
            Sample start;
            ThreadMXBean bean = ManagementFactory.getThreadMXBean();
            if (threadId == -1L) {
                long current = Thread.currentThread().getId();
                start = this.global(bean, current);
                Thread.sleep(interval);
                end = this.global(bean, current);
            } else {
                start = this.single(bean, threadId);
                Thread.sleep(interval);
                end = this.single(bean, threadId);
            }
            long time = end.time() - start.time();
            long user = end.user() - start.user();
            long cpu = end.cpu() - start.cpu();
            xml.openElement("sample");
            xml.attribute("interval", Long.toString(interval));
            xml.attribute("cpu", Long.toString(cpu * 100L / time));
            xml.attribute("user", Long.toString(user * 100L / time));
            xml.attribute("system", Long.toString((cpu - user) * 100L / time));
            xml.closeElement();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Sample global(ThreadMXBean bean, long current) {
        long[] _ids;
        long cpu = 0L;
        long user = 0L;
        for (long id : _ids = bean.getAllThreadIds()) {
            if (id == current) continue;
            long _c = bean.getThreadCpuTime(id);
            long _u = bean.getThreadUserTime(id);
            if (_c == -1L || _u == -1L) continue;
            cpu += _c;
            user += _u;
        }
        return new Sample(cpu, user);
    }

    private Sample single(ThreadMXBean bean, long id) {
        long _cpu = bean.getThreadCpuTime(id);
        long _user = bean.getThreadUserTime(id);
        if (_cpu == -1L || _user == -1L) {
            return new Sample(0L, 0L);
        }
        return new Sample(_cpu, _user);
    }

    private static class Sample {
        public final long _time = System.nanoTime();
        public final long _cpu;
        public final long _user;

        public Sample(long cpu, long user) {
            this._cpu = cpu;
            this._user = user;
        }

        public long cpu() {
            return this._cpu;
        }

        public long user() {
            return this._user;
        }

        public long time() {
            return this._time;
        }
    }
}

