/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.pageseeder.berlioz.content.PathInfo;
import org.pageseeder.xmlwriter.XMLWriter;

public final class HttpPathInfo
implements PathInfo,
Serializable {
    private static final long serialVersionUID = -2025665764421725251L;
    private final String _context;
    private final String _extension;
    private final String _prefix;
    private final String _path;

    protected HttpPathInfo(HttpServletRequest req) {
        this._context = req.getContextPath();
        if (req.getPathInfo() != null) {
            String path = req.getPathInfo();
            this._path = path != null ? path : "";
            this._prefix = req.getServletPath();
            this._extension = "";
        } else {
            String path = req.getServletPath();
            int dot = path.lastIndexOf(46);
            this._path = dot != -1 ? path.substring(0, dot) : path;
            this._prefix = "";
            this._extension = dot != -1 ? path.substring(dot) : "";
        }
    }

    @Override
    public String context() {
        return this._context;
    }

    @Override
    public String extension() {
        return this._extension;
    }

    @Override
    public String path() {
        return this._path;
    }

    @Override
    public String prefix() {
        return this._prefix;
    }

    public void toXML(XMLWriter xml) throws IOException {
        xml.openElement("path");
        if (this._context.length() > 0) {
            xml.attribute("context", this._context);
        }
        if (this._prefix.length() > 0) {
            xml.attribute("prefix", this._prefix);
        }
        xml.attribute("info", this._path);
        if (this._extension.length() > 0) {
            xml.attribute("extension", this._extension);
        }
        xml.closeElement();
    }

    public String toString() {
        return this._context + this._prefix + this._path + this._extension;
    }
}

