/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.io.File;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.GlobalSettings;
import org.pageseeder.berlioz.content.Environment;

public final class HttpEnvironment
implements Environment {
    private final File _public;
    private final File _private;
    private final String _cacheControl;

    public HttpEnvironment(File publicDir, File privateDir, String cacheControl) {
        this._public = publicDir;
        this._private = privateDir;
        this._cacheControl = cacheControl;
    }

    @Override
    public File getPublicFolder() {
        return this._public;
    }

    @Override
    public File getPrivateFolder() {
        return this._private;
    }

    @Override
    public File getPrivateFile(String path) {
        return new File(this._private, path);
    }

    @Override
    public File getPublicFile(String path) {
        return new File(this._public, path);
    }

    @Override
    public @Nullable String getProperty(String name) {
        return GlobalSettings.get(name);
    }

    @Override
    public boolean getProperty(String name, boolean def) {
        return GlobalSettings.get(name, def);
    }

    @Override
    public int getProperty(String name, int def) {
        return GlobalSettings.get(name, def);
    }

    @Override
    public String getProperty(String name, String def) {
        return GlobalSettings.get(name, def);
    }

    public String getCacheControl() {
        return this._cacheControl;
    }
}

