/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.servlet;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.content.ContentGenerator;
import org.pageseeder.berlioz.content.ContentRequest;
import org.pageseeder.berlioz.content.ContentStatus;
import org.pageseeder.berlioz.content.Service;
import org.pageseeder.berlioz.servlet.CoreHttpRequest;
import org.pageseeder.berlioz.servlet.HttpRequestWrapper;

public final class HttpContentRequest
extends HttpRequestWrapper
implements ContentRequest {
    private final ContentGenerator _generator;
    private final Service _service;
    private final int _order;
    private ContentStatus status = ContentStatus.OK;
    private @Nullable String redirectTo = null;
    private long profile = 0L;

    protected HttpContentRequest(CoreHttpRequest core, Map<String, String> parameters, ContentGenerator generator, Service service, int order) {
        super(core, parameters);
        this._generator = Objects.requireNonNull(generator, "The generator is required");
        this._service = Objects.requireNonNull(service, "The service is required");
        this._order = order;
    }

    @Override
    public void setStatus(ContentStatus status) {
        Objects.requireNonNull(status, "Cannot set status to null");
        if (ContentStatus.isRedirect(status)) {
            throw new IllegalArgumentException("Unable to use redirect status code:" + (Object)((Object)status));
        }
        this.status = status;
    }

    @Override
    public void setRedirect(String url, @Nullable ContentStatus status) {
        Objects.requireNonNull(url, "Cannot set URL to null");
        if (status != null) {
            if (!ContentStatus.isRedirect(status)) {
                throw new IllegalArgumentException("Invalid redirect status:" + (Object)((Object)status));
            }
            this.status = status;
        } else {
            this.status = ContentStatus.TEMPORARY_REDIRECT;
        }
        this.redirectTo = url;
    }

    public ContentStatus getStatus() {
        return this.status;
    }

    public ContentGenerator generator() {
        return this._generator;
    }

    public Service getService() {
        return this._service;
    }

    public @Nullable String getRedirectURL() {
        return this.redirectTo;
    }

    protected int order() {
        return this._order;
    }

    protected void setProfileEtag(long profile) {
        this.profile = profile;
    }

    protected long getProfileEtag() {
        return this.profile;
    }
}

