/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.output;

import java.io.StringWriter;
import java.io.Writer;
import org.pageseeder.berlioz.Beta;
import org.pageseeder.berlioz.json.Json;
import org.pageseeder.berlioz.json.JsonWriter;
import org.pageseeder.berlioz.output.OutputType;
import org.pageseeder.berlioz.output.UniversalWriter;

@Beta
public class JsonUniversalAdapter
implements UniversalWriter {
    private final JsonWriter _json;

    public JsonUniversalAdapter() {
        this(new StringWriter());
    }

    public JsonUniversalAdapter(Writer out) {
        this._json = Json.newWriter(out);
    }

    @Override
    public final OutputType getType() {
        return OutputType.JSON;
    }

    @Override
    public final void field(String name, boolean value, UniversalWriter.FieldOption option) {
        this._json.field(Json.camelify(name), value);
    }

    @Override
    public final void field(String name, long value, UniversalWriter.FieldOption option) {
        this._json.field(Json.camelify(name), value);
    }

    @Override
    public final void field(String name, double value, UniversalWriter.FieldOption option) {
        this._json.field(Json.camelify(name), value);
    }

    @Override
    public final void field(String name, String value, UniversalWriter.FieldOption option) {
        this._json.field(Json.camelify(name), value);
    }

    @Override
    public void startObject(String name, UniversalWriter.ContextOption option) {
        if (this._json.inObject()) {
            this._json.startObject(Json.camelify(name));
        } else {
            this._json.startObject();
        }
    }

    @Override
    public void endObject() {
        this._json.endObject();
    }

    @Override
    public void startArray(String name, UniversalWriter.ContextOption option) {
        if (this._json.inObject()) {
            this._json.startArray(Json.camelify(name));
        } else {
            this._json.startArray();
        }
    }

    @Override
    public void endArray() {
        this._json.endArray();
    }

    @Override
    public void flush() {
        this._json.flush();
    }

    @Override
    public void close() {
        this._json.close();
    }

    public String toString() {
        this.flush();
        return super.toString();
    }
}

