/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.json;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.pageseeder.berlioz.json.JsonWriteFailureException;
import org.pageseeder.berlioz.json.JsonWriter;

final class GsonJsonWriter
implements JsonWriter {
    private final com.google.gson.stream.JsonWriter _json;
    private boolean[] inObject = new boolean[64];
    private int level = -1;
    private boolean needComma = false;

    private GsonJsonWriter(com.google.gson.stream.JsonWriter json) {
        this._json = json;
    }

    @Override
    public JsonWriter startArray(String name) {
        this.inObject[++this.level] = false;
        try {
            this._json.name(name).beginArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startArray() {
        this.inObject[++this.level] = false;
        try {
            this._json.beginArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter endArray() {
        --this.level;
        try {
            this._json.endArray();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startObject(String name) {
        this.inObject[++this.level] = true;
        try {
            this._json.name(name).beginObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter startObject() {
        this.inObject[++this.level] = true;
        try {
            this._json.beginObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter endObject() {
        --this.level;
        try {
            this._json.endObject();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter name(String name) {
        try {
            this._json.name(name);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter nullValue(String name) {
        try {
            this._json.name(name).nullValue();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter nullValue() {
        try {
            this._json.nullValue();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(double number) {
        try {
            this._json.value(number);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(long number) {
        try {
            this._json.value(number);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(String value) {
        try {
            this._json.value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter value(boolean value) {
        try {
            this._json.value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, String value) {
        try {
            this._json.name(name).value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, boolean value) {
        try {
            this._json.name(name).value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, double value) {
        try {
            this._json.name(name).value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public JsonWriter field(String name, long value) {
        try {
            this._json.name(name).value(value);
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
        return this;
    }

    @Override
    public boolean inObject() {
        return this.level >= 0 && this.inObject[this.level];
    }

    @Override
    public void close() {
        try {
            this._json.close();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    @Override
    public void flush() {
        try {
            this._json.flush();
        }
        catch (IOException ex) {
            throw new JsonWriteFailureException(ex);
        }
    }

    public static GsonJsonWriter newInstance(OutputStream out) {
        com.google.gson.stream.JsonWriter json = new com.google.gson.stream.JsonWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
        return new GsonJsonWriter(json);
    }

    public static GsonJsonWriter newInstance(Writer writer) {
        return new GsonJsonWriter(new com.google.gson.stream.JsonWriter(writer));
    }

    private void push(boolean isObject) {
        ++this.level;
        if (this.level < this.inObject.length) {
            this.inObject[this.level] = isObject;
        } else {
            this.inObject = Arrays.copyOf(this.inObject, this.inObject.length * 2);
        }
    }
}

