/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.http;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.pageseeder.berlioz.http.PerformanceServerTiming;

public final class ServerTimingHeader {
    private final List<PerformanceServerTiming> _timings = new ArrayList<PerformanceServerTiming>();

    public void add(PerformanceServerTiming timing) {
        this._timings.add(timing);
    }

    public void addMetric(String name) {
        this._timings.add(new PerformanceServerTiming(name, -1.0));
    }

    public void addMetric(String name, double durationMillis) {
        this._timings.add(new PerformanceServerTiming(name, durationMillis));
    }

    public void addMetric(String name, String description) {
        this._timings.add(new PerformanceServerTiming(name, description, -1.0));
    }

    public void addMetric(String name, String description, double durationMillis) {
        this._timings.add(new PerformanceServerTiming(name, description, durationMillis));
    }

    public void addMetricNano(String name, double durationNano) {
        this._timings.add(new PerformanceServerTiming(name, durationNano * 1.0E-6));
    }

    public void addMetricNano(String name, String description, long durationNano) {
        this._timings.add(new PerformanceServerTiming(name, description, (double)durationNano * 1.0E-6));
    }

    public String toValue() {
        return this._timings.stream().map(PerformanceServerTiming::toHeaderString).collect(Collectors.joining(", "));
    }

    public static void addMetricNano(HttpServletResponse response, String name, String description, long durationNano) {
        PerformanceServerTiming metric = new PerformanceServerTiming(name, description, (double)durationNano * 1.0E-6);
        response.addHeader("Server-Timing", metric.toHeaderString());
    }

    public void addHeaderTo(HttpServletResponse response) {
        response.addHeader("Server-Timing", this.toValue());
    }
}

