/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.http;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;

public final class HttpStatusCodes {
    private static final Map<Integer, String> HTTP_CODE_TITLE = new HashMap<Integer, String>();

    private HttpStatusCodes() {
    }

    public static @Nullable String getTitle(int code) {
        return HTTP_CODE_TITLE.get(code);
    }

    public static @Nullable String getClassOfStatus(int code) {
        int x = code / 100;
        switch (x) {
            case 1: {
                return "Informational";
            }
            case 2: {
                return "Successful";
            }
            case 3: {
                return "Redirection";
            }
            case 4: {
                return "Client Error";
            }
            case 5: {
                return "Server Error";
            }
        }
        return null;
    }

    static {
        HTTP_CODE_TITLE.put(100, "Continue");
        HTTP_CODE_TITLE.put(101, "Switching Protocols");
        HTTP_CODE_TITLE.put(200, "OK");
        HTTP_CODE_TITLE.put(201, "Created");
        HTTP_CODE_TITLE.put(202, "Accepted");
        HTTP_CODE_TITLE.put(203, "Non-Authoritative Information");
        HTTP_CODE_TITLE.put(204, "No Content");
        HTTP_CODE_TITLE.put(205, "Reset Content");
        HTTP_CODE_TITLE.put(206, "Partial Content");
        HTTP_CODE_TITLE.put(300, "Multiple Choices");
        HTTP_CODE_TITLE.put(301, "Moved Permanently");
        HTTP_CODE_TITLE.put(302, "Found");
        HTTP_CODE_TITLE.put(303, "See Other");
        HTTP_CODE_TITLE.put(304, "Not Modified");
        HTTP_CODE_TITLE.put(305, "Use Proxy");
        HTTP_CODE_TITLE.put(307, "Temporary Redirect");
        HTTP_CODE_TITLE.put(400, "Bad Request");
        HTTP_CODE_TITLE.put(401, "Unauthorized");
        HTTP_CODE_TITLE.put(402, "Payment Required");
        HTTP_CODE_TITLE.put(403, "Forbidden");
        HTTP_CODE_TITLE.put(404, "Not Found");
        HTTP_CODE_TITLE.put(405, "Method Not Allowed");
        HTTP_CODE_TITLE.put(406, "Not Acceptable");
        HTTP_CODE_TITLE.put(407, "Proxy Authentication Required");
        HTTP_CODE_TITLE.put(408, "Request Timeout");
        HTTP_CODE_TITLE.put(409, "Conflict");
        HTTP_CODE_TITLE.put(410, "Gone");
        HTTP_CODE_TITLE.put(411, "Length Required");
        HTTP_CODE_TITLE.put(412, "Precondition Failed");
        HTTP_CODE_TITLE.put(413, "Request Entity Too Large");
        HTTP_CODE_TITLE.put(414, "Request-URI Too Long");
        HTTP_CODE_TITLE.put(415, "Unsupported Media Type");
        HTTP_CODE_TITLE.put(416, "Requested Range Not Satisfiable");
        HTTP_CODE_TITLE.put(417, "Expectation Failed");
        HTTP_CODE_TITLE.put(500, "Internal Server Error");
        HTTP_CODE_TITLE.put(501, "Not Implemented");
        HTTP_CODE_TITLE.put(502, "Bad Gateway");
        HTTP_CODE_TITLE.put(503, "Service Unavailable");
        HTTP_CODE_TITLE.put(504, "Gateway Timeout");
        HTTP_CODE_TITLE.put(505, "HTTP Version Not Supported");
    }
}

