/*
 * Decompiled with CFR 0.152.
 */
package org.pageseeder.berlioz.furi;

import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.furi.Parameters;
import org.pageseeder.berlioz.furi.URITemplateSyntaxException;
import org.pageseeder.berlioz.furi.VariableType;

public class Variable {
    private static final Pattern VALID_NAME = Pattern.compile("[a-zA-Z0-9][\\w.-]*");
    protected static final Pattern VALID_VALUE = Pattern.compile("(?:[\\w.~@-]|(?:%[0-9A-F]{2}))+");
    private static final String DEFAULT_VALUE = "";
    private Form form;
    private @Nullable VariableType type;
    private final String _name;
    private final String _default;

    public Variable(Reserved reserved) {
        this._name = reserved.symbol();
        this._default = DEFAULT_VALUE;
        this.form = Form.STRING;
        this.type = null;
    }

    public Variable(String name) {
        this(name, DEFAULT_VALUE);
    }

    public Variable(String name, @Nullable String def) {
        this(name, def, null);
    }

    public Variable(String name, @Nullable String def, @Nullable VariableType type) {
        this._name = Objects.requireNonNull(name, "A variable must have a name, but was null");
        this._default = Objects.toString(def, DEFAULT_VALUE);
        this.type = type;
        this.form = Form.getType(name);
        if (!Variable.isValidName(name)) {
            throw new IllegalArgumentException("The variable name is not valid: " + name);
        }
    }

    public Variable(String name, String def, VariableType type, Form form) {
        this._name = Objects.requireNonNull(name, "A variable must have a name, but was null");
        this._default = def != null ? def : DEFAULT_VALUE;
        this.type = type;
        Form form2 = this.form = form != null ? form : Form.STRING;
        if (!Variable.isValidName(name)) {
            throw new IllegalArgumentException("The variable name is not valid: " + name);
        }
    }

    public Form form() {
        return this.form;
    }

    public String name() {
        return this._name;
    }

    public String defaultValue() {
        return this._default;
    }

    public @Nullable VariableType type() {
        return this.type;
    }

    public String value(@Nullable Parameters parameters) {
        if (parameters == null) {
            return this._default;
        }
        String[] values = parameters.getValues(this._name);
        if (values != null && values.length > 0 && values[0] != null) {
            return values[0];
        }
        return this._default;
    }

    public String[] values(@Nullable Parameters parameters) {
        if (parameters == null) {
            return new String[]{this._default};
        }
        String[] values = parameters.getValues(this._name);
        if (values != null && values.length > 0 && values[0].length() > 0) {
            return values;
        }
        return new String[]{this._default};
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        Variable v = (Variable)o;
        return this._name.equals(v._name) && this._default.equals(v._default);
    }

    public int hashCode() {
        return this._name.hashCode() + 7 * this._default.hashCode();
    }

    public String toString() {
        if (this._default.length() > 0) {
            return this._name + '=' + this._default;
        }
        return this._name;
    }

    public static Variable parse(String exp) throws URITemplateSyntaxException {
        int colon;
        Form f = Form.getType(exp);
        if (f != Form.STRING) {
            exp = exp.substring(1);
        }
        if ((colon = exp.indexOf(58)) < 0) {
            Variable v = Variable.parseUntyped(exp);
            v.form = f;
            return v;
        }
        if (colon == 0) {
            Variable v = Variable.parseUntyped(exp.substring(1));
            v.form = f;
            return v;
        }
        Variable v = Variable.parseUntyped(exp.substring(colon + 1));
        v.type = new VariableType(exp.substring(0, colon));
        v.form = f;
        return v;
    }

    private static Variable parseUntyped(String exp) throws URITemplateSyntaxException {
        int equal = exp.indexOf(61);
        if (equal == 0) {
            throw new URITemplateSyntaxException(exp, "Variable name is empty string");
        }
        if (equal > 0) {
            return new Variable(exp.substring(0, equal), exp.substring(equal + 1));
        }
        return new Variable(exp, null);
    }

    public static boolean isValidName(@Nullable String name) {
        if (name == null) {
            return false;
        }
        return VALID_NAME.matcher(name).matches();
    }

    public static boolean isValidValue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        return VALID_VALUE.matcher(value).matches();
    }

    protected String namePatternString() {
        return this._name.indexOf(46) < 0 ? this._name : this.name().replaceAll("\\.", "\\\\.");
    }

    public static enum Modifier {
        SUBSTRING,
        REMAINDER;

    }

    public static enum Form {
        STRING,
        LIST,
        MAP;


        protected static Form getType(String exp) {
            if (exp.length() == 0) {
                return STRING;
            }
            char c = exp.charAt(0);
            if (c == '@') {
                return LIST;
            }
            if (c == '%') {
                return MAP;
            }
            return STRING;
        }
    }

    public static enum Reserved {
        WILDCARD("*");

        private final String _symbol;

        private Reserved(String symbol) {
            this._symbol = symbol;
        }

        String symbol() {
            return this._symbol;
        }
    }
}

